/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LinearChassisBlock
extends AbstractChassisBlock {
    public static final BooleanProperty STICKY_TOP = BooleanProperty.create((String)"sticky_top");
    public static final BooleanProperty STICKY_BOTTOM = BooleanProperty.create((String)"sticky_bottom");

    public LinearChassisBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)STICKY_TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)STICKY_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STICKY_TOP, STICKY_BOTTOM});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos placedOnPos = context.getClickedPos().relative(context.getClickedFace().getOpposite());
        BlockState blockState = context.getLevel().getBlockState(placedOnPos);
        if (context.getPlayer() == null || !context.getPlayer().isShiftKeyDown()) {
            if (LinearChassisBlock.isChassis(blockState)) {
                return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)blockState.getValue((Property)AXIS)));
            }
            return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)context.getNearestLookingDirection().getAxis());
        }
        return super.getStateForPlacement(context);
    }

    public BlockState updateShape(BlockState state, LevelReader p_196271_4_, ScheduledTickAccess tickView, BlockPos p_196271_5_, Direction side, BlockPos p_196271_6_, BlockState other, RandomSource random) {
        BooleanProperty property = this.getGlueableSide(state, side);
        if (property == null || !LinearChassisBlock.sameKind(state, other) || state.getValue((Property)AXIS) != other.getValue((Property)AXIS)) {
            return state;
        }
        return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BooleanProperty getGlueableSide(BlockState state, Direction face) {
        if (face.getAxis() != state.getValue((Property)AXIS)) {
            return null;
        }
        return face.getAxisDirection() == Direction.AxisDirection.POSITIVE ? STICKY_TOP : STICKY_BOTTOM;
    }

    @Override
    protected boolean glueAllowedOnSide(BlockGetter world, BlockPos pos, BlockState state, Direction side) {
        BlockState other = world.getBlockState(pos.relative(side));
        return !LinearChassisBlock.sameKind(other, state) || state.getValue((Property)AXIS) != other.getValue((Property)AXIS);
    }

    public static boolean isChassis(BlockState state) {
        return state.is((Block)AllBlocks.LINEAR_CHASSIS) || state.is((Block)AllBlocks.SECONDARY_LINEAR_CHASSIS);
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.getBlock() == state2.getBlock();
    }
}

