/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.elevator;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElevatorContactBlock
extends WrenchableDirectionalBlock
implements IBE<ElevatorContactBlockEntity>,
SpecialBlockItemRequirement,
RedStoneConnectBlock,
WeakPowerControlBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty CALLING = BooleanProperty.create((String)"calling");
    public static final BooleanProperty POWERING = BrassDiodeBlock.POWERING;
    public static final MapCodec<ElevatorContactBlock> CODEC = ElevatorContactBlock.simpleCodec(ElevatorContactBlock::new);

    public ElevatorContactBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CALLING, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERING, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{CALLING, POWERING, POWERED}));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched != InteractionResult.SUCCESS) {
            return onWrenched;
        }
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return onWrenched;
        }
        BlockPos pos = context.getClickedPos();
        state = level.getBlockState(pos);
        Direction facing = (Direction)state.getValue((Property)RedstoneContactBlock.FACING);
        if (facing.getAxis() != Direction.Axis.Y && ElevatorColumn.get((LevelAccessor)level, new ElevatorColumn.ColumnCoords(pos.getX(), pos.getZ(), facing)) != null) {
            return onWrenched;
        }
        level.setBlockAndUpdate(pos, BlockHelper.copyProperties(state, AllBlocks.REDSTONE_CONTACT.defaultBlockState()));
        return onWrenched;
    }

    @Nullable
    public static ElevatorColumn.ColumnCoords getColumnCoords(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.is((Block)AllBlocks.ELEVATOR_CONTACT) && !blockState.is((Block)AllBlocks.REDSTONE_CONTACT)) {
            return null;
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        BlockPos target = pos;
        return new ElevatorColumn.ColumnCoords(target.getX(), target.getZ(), facing);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, @Nullable Orientation wireOrientation, boolean pIsMoving) {
        if (pLevel.isClientSide()) {
            return;
        }
        boolean isPowered = (Boolean)pState.getValue((Property)POWERED);
        if (isPowered == pLevel.hasNeighborSignal(pPos)) {
            return;
        }
        pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        if (isPowered) {
            return;
        }
        if (((Boolean)pState.getValue((Property)CALLING)).booleanValue()) {
            return;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.getOrCreate((LevelAccessor)pLevel, ElevatorContactBlock.getColumnCoords((LevelAccessor)pLevel, pPos));
        this.callToContactAndUpdate(elevatorColumn, pState, pLevel, pPos, true);
    }

    public void callToContactAndUpdate(ElevatorColumn elevatorColumn, BlockState pState, Level pLevel, BlockPos pPos, boolean powered) {
        pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)CALLING), 2);
        for (BlockPos otherPos : elevatorColumn.getContacts()) {
            BlockState otherState;
            if (otherPos.equals((Object)pPos) || !(otherState = pLevel.getBlockState(otherPos)).is((Block)AllBlocks.ELEVATOR_CONTACT)) continue;
            pLevel.setBlock(otherPos, (BlockState)otherState.setValue((Property)CALLING, (Comparable)Boolean.valueOf(false)), 18);
            this.scheduleActivation((ScheduledTickAccess)pLevel, otherPos);
        }
        if (powered) {
            pState = (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CALLING, (Comparable)Boolean.valueOf(true)), 2);
        pLevel.updateNeighborsAt(pPos, (Block)this, null);
        elevatorColumn.target(pPos.getY());
        elevatorColumn.markDirty();
    }

    public void scheduleActivation(ScheduledTickAccess pLevel, BlockPos pPos) {
        if (!pLevel.getBlockTicks().hasScheduledTick(pPos, (Object)this)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        boolean wasPowering = (Boolean)pState.getValue((Property)POWERING);
        Optional optionalBE = this.getBlockEntityOptional((BlockGetter)pLevel, pPos);
        boolean shouldBePowering = optionalBE.map(be -> {
            boolean activateBlock = be.activateBlock;
            be.activateBlock = false;
            be.setChanged();
            return activateBlock;
        }).orElse(false);
        if (wasPowering || (shouldBePowering |= RedstoneContactBlock.hasValidContact((LevelReader)pLevel, pPos, (Direction)pState.getValue((Property)FACING)))) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERING, (Comparable)Boolean.valueOf(shouldBePowering)), 18);
        }
        pLevel.updateNeighborsAt(pPos, (Block)this, null);
    }

    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess tickView, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (facing != stateIn.getValue((Property)FACING)) {
            return stateIn;
        }
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(worldIn, currentPos, facing);
        if ((Boolean)stateIn.getValue((Property)POWERING) != hasValidContact) {
            this.scheduleActivation(tickView, currentPos);
        }
        return stateIn;
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERING);
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return AllItems.REDSTONE_CONTACT.getDefaultInstance();
    }

    @Override
    public boolean canConnectRedstone(BlockState state, @Nullable Direction side) {
        if (side == null) {
            return true;
        }
        return state.getValue((Property)FACING) != side.getOpposite();
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side == null) {
            return 0;
        }
        BlockState toState = blockAccess.getBlockState(pos.relative(side.getOpposite()));
        if (toState.is((Block)this)) {
            return 0;
        }
        return (Boolean)state.getValue((Property)POWERING) != false ? 15 : 0;
    }

    @Override
    public Class<ElevatorContactBlockEntity> getBlockEntityClass() {
        return ElevatorContactBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ElevatorContactBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ELEVATOR_CONTACT;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return ItemRequirement.of(AllBlocks.REDSTONE_CONTACT.defaultBlockState(), be);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player != null && stack.is((Item)AllItems.WRENCH)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> AllClientHandle.INSTANCE.openElevatorContactScreen((ElevatorContactBlockEntity)be, player));
        }
        return InteractionResult.SUCCESS;
    }

    public static int getLight(BlockState state) {
        return (Boolean)state.getValue((Property)POWERING) != false ? 10 : 0;
    }

    @Override
    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

