/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.glue;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.levelWrappers.RayTraceLevel;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.infrastructure.packet.s2c.GlueEffectPacket;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SuperGlueHandler {
    public static void glueListensForBlockPlacement(ServerLevel world, Player player, BlockPos pos) {
        HashSet<SuperGlueEntity> cached = new HashSet<SuperGlueEntity>();
        for (Direction direction : Iterate.directions) {
            BlockPos relative = pos.relative(direction);
            if (!SuperGlueEntity.isGlued((LevelAccessor)world, pos, direction, cached) || !BlockMovementChecks.isMovementNecessary(world.getBlockState(relative), (Level)world, relative)) continue;
            world.getChunkSource().sendToTrackingPlayersAndSelf((Entity)player, (Packet)new GlueEffectPacket(pos, direction, true));
        }
        SuperGlueHandler.glueInOffHandAppliesOnBlockPlace(world, player, pos);
    }

    public static void glueInOffHandAppliesOnBlockPlace(ServerLevel world, Player placer, BlockPos pos) {
        AttributeInstance reachAttribute = placer.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (reachAttribute == null) {
            return;
        }
        ItemStack itemstack = placer.getOffhandItem();
        if (!itemstack.is((Item)AllItems.SUPER_GLUE)) {
            return;
        }
        if (placer.getMainHandItem().is((Item)AllItems.WRENCH)) {
            return;
        }
        double distance = reachAttribute.getValue();
        Vec3 start = placer.getEyePosition(1.0f);
        Vec3 look = placer.getViewVector(1.0f);
        RayTraceLevel rayTraceLevel = new RayTraceLevel((LevelAccessor)world, (p, state) -> p.equals((Object)pos) ? Blocks.AIR.defaultBlockState() : state);
        Vec3 end = start.add(look.x * distance, look.y * distance, look.z * distance);
        BlockHitResult ray = rayTraceLevel.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)placer));
        Direction face = ray.getDirection();
        if (face == null || ray.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockPos gluePos = ray.getBlockPos();
        if (!gluePos.relative(face).equals((Object)pos)) {
            return;
        }
        if (SuperGlueEntity.isGlued((LevelAccessor)world, gluePos, face, null)) {
            return;
        }
        SuperGlueEntity entity = new SuperGlueEntity((Level)world, SuperGlueEntity.span(gluePos, gluePos.relative(face)));
        CustomData customData = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            EntityType.updateCustomEntityTag((Level)world, (LivingEntity)placer, (Entity)entity, (TypedEntityData)TypedEntityData.of((Object)entity.getType(), (CompoundTag)customData.copyTag()));
        }
        if (SuperGlueEntity.isValidFace((Level)world, gluePos, face)) {
            world.addFreshEntity((Entity)entity);
            world.getChunkSource().sendToTrackingPlayers((Entity)entity, (Packet)new GlueEffectPacket(gluePos, face, true));
            itemstack.hurtAndBreak(1, (LivingEntity)placer, EquipmentSlot.MAINHAND);
        }
    }
}

