/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.math.VecHelper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.entity.vehicle.minecart.MinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.MinecartFurnace;
import net.minecraft.world.entity.vehicle.minecart.OldMinecartBehavior;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class MinecartSim2020 {
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> MATRIX = (Map)Util.make((Object)Maps.newEnumMap(RailShape.class), map -> {
        Vec3i west = Direction.WEST.getUnitVec3i();
        Vec3i east = Direction.EAST.getUnitVec3i();
        Vec3i north = Direction.NORTH.getUnitVec3i();
        Vec3i south = Direction.SOUTH.getUnitVec3i();
        map.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        map.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        map.put(RailShape.ASCENDING_EAST, Pair.of((Object)west.below(), (Object)east));
        map.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)east.below()));
        map.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)south.below()));
        map.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)north.below(), (Object)south));
        map.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        map.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        map.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        map.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });

    public static Vec3 predictNextPositionOf(AbstractMinecart cart) {
        Vec3 position = cart.position();
        Vec3 motion = VecHelper.clamp(cart.getDeltaMovement(), 1.0f);
        return position.add(motion);
    }

    public static boolean canAddMotion(AbstractMinecart c) {
        if (c instanceof MinecartFurnace) {
            MinecartFurnace furnace = (MinecartFurnace)c;
            return Mth.equal((double)furnace.push.x, (double)0.0) && Mth.equal((double)furnace.push.z, (double)0.0);
        }
        return AllSynchedDatas.MINECART_CONTROLLER.get((Entity)c).map(controller -> !controller.isStalled()).orElse(true);
    }

    public static void moveCartAlongTrack(ServerLevel world, AbstractMinecart cart, Vec3 forcedMovement, BlockPos cartPos, BlockState trackState) {
        double d14;
        if (forcedMovement.equals((Object)Vec3.ZERO)) {
            return;
        }
        Vec3 previousMotion = cart.getDeltaMovement();
        cart.fallDistance = 0.0;
        double x = cart.getX();
        double y = cart.getY();
        double z = cart.getZ();
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        MinecartBehavior minecartBehavior = cart.getBehavior();
        if (!(minecartBehavior instanceof OldMinecartBehavior)) {
            return;
        }
        OldMinecartBehavior controller = (OldMinecartBehavior)minecartBehavior;
        Vec3 actualVec = controller.getPos(actualX, actualY, actualZ);
        actualY = cartPos.getY() + 1;
        BaseRailBlock abstractrailblock = (BaseRailBlock)trackState.getBlock();
        RailShape railshape = (RailShape)trackState.getValue(abstractrailblock.getShapeProperty());
        switch (railshape) {
            case ASCENDING_EAST: {
                forcedMovement = forcedMovement.add(-0.0078125, 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                forcedMovement = forcedMovement.add(0.0078125, 0.0, 0.0);
                actualY += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                forcedMovement = forcedMovement.add(0.0, 0.0, 0.0078125);
                actualY += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                forcedMovement = forcedMovement.add(0.0, 0.0, -0.0078125);
                actualY += 1.0;
            }
        }
        Pair<Vec3i, Vec3i> pair = MATRIX.get(railshape);
        Vec3i Vector3i = (Vec3i)pair.getFirst();
        Vec3i Vector3i1 = (Vec3i)pair.getSecond();
        double d4 = Vector3i1.getX() - Vector3i.getX();
        double d5 = Vector3i1.getZ() - Vector3i.getZ();
        double d7 = forcedMovement.x * d4 + forcedMovement.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d23 = (double)cartPos.getX() + 0.5 + (double)Vector3i.getX() * 0.5;
        double d10 = (double)cartPos.getZ() + 0.5 + (double)Vector3i.getZ() * 0.5;
        double d12 = (double)cartPos.getX() + 0.5 + (double)Vector3i1.getX() * 0.5;
        double d13 = (double)cartPos.getZ() + 0.5 + (double)Vector3i1.getZ() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = actualZ - (double)cartPos.getZ();
        } else if (d5 == 0.0) {
            d14 = actualX - (double)cartPos.getX();
        } else {
            double d15 = actualX - d23;
            double d16 = actualZ - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        actualX = d23 + d4 * d14;
        actualZ = d10 + d5 * d14;
        cart.setPos(actualX, actualY, actualZ);
        cart.setDeltaMovement(forcedMovement);
        double s = cart.isVehicle() ? 0.75 : 1.0;
        double t = controller.getMaxSpeed(world);
        Vec3 vec3d2 = cart.getDeltaMovement();
        cart.move(MoverType.SELF, new Vec3(Mth.clamp((double)(s * vec3d2.x), (double)(-t), (double)t), 0.0, Mth.clamp((double)(s * vec3d2.z), (double)(-t), (double)t)));
        x = cart.getX();
        y = cart.getY();
        z = cart.getZ();
        if (Vector3i.getY() != 0 && Mth.floor((double)x) - cartPos.getX() == Vector3i.getX() && Mth.floor((double)z) - cartPos.getZ() == Vector3i.getZ()) {
            cart.setPos(x, y + (double)Vector3i.getY(), z);
        } else if (Vector3i1.getY() != 0 && Mth.floor((double)x) - cartPos.getX() == Vector3i1.getX() && Mth.floor((double)z) - cartPos.getZ() == Vector3i1.getZ()) {
            cart.setPos(x, y + (double)Vector3i1.getY(), z);
        }
        x = cart.getX();
        y = cart.getY();
        z = cart.getZ();
        Vec3 Vector3d3 = controller.getPos(x, y, z);
        if (Vector3d3 != null && actualVec != null) {
            double d17 = (actualVec.y - Vector3d3.y) * 0.05;
            Vec3 Vector3d4 = cart.getDeltaMovement();
            double d18 = Math.sqrt(Vector3d4.horizontalDistanceSqr());
            if (d18 > 0.0) {
                cart.setDeltaMovement(Vector3d4.multiply((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            cart.setPos(x, Vector3d3.y, z);
        }
        x = cart.getX();
        y = cart.getY();
        z = cart.getZ();
        int j = Mth.floor((double)x);
        int i = Mth.floor((double)z);
        if (j != cartPos.getX() || i != cartPos.getZ()) {
            Vec3 Vector3d5 = cart.getDeltaMovement();
            double d26 = Math.sqrt(Vector3d5.horizontalDistanceSqr());
            cart.setDeltaMovement(d26 * (double)(j - cartPos.getX()), Vector3d5.y, d26 * (double)(i - cartPos.getZ()));
        }
        cart.setDeltaMovement(previousMotion);
    }

    public static Vec3 getRailVec(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH, RailShape.NORTH_SOUTH -> new Vec3(0.0, 0.0, 1.0);
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.EAST_WEST -> new Vec3(1.0, 0.0, 0.0);
            case RailShape.NORTH_EAST, RailShape.SOUTH_WEST -> new Vec3(1.0, 0.0, 1.0).normalize();
            case RailShape.NORTH_WEST, RailShape.SOUTH_EAST -> new Vec3(1.0, 0.0, -1.0).normalize();
            default -> new Vec3(0.0, 1.0, 0.0);
        };
    }
}

