/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MechanicalPistonBlock
extends DirectionalAxisKineticBlock
implements IBE<MechanicalPistonBlockEntity>,
NeighborUpdateListeningBlock {
    public static final EnumProperty<PistonState> STATE = EnumProperty.create((String)"state", PistonState.class);
    protected boolean isSticky;

    public static MechanicalPistonBlock normal(BlockBehaviour.Properties properties) {
        return new MechanicalPistonBlock(properties, false);
    }

    public static MechanicalPistonBlock sticky(BlockBehaviour.Properties properties) {
        return new MechanicalPistonBlock(properties, true);
    }

    protected MechanicalPistonBlock(BlockBehaviour.Properties properties, boolean sticky) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)PistonState.RETRACTED)));
        this.isSticky = sticky;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STATE});
        super.createBlockStateDefinition(builder);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.mayBuild()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!stack.is(AllItemTags.SLIME_BALLS)) {
            if (stack.isEmpty()) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                    be.assembleNextTick = true;
                });
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (state.getValue(STATE) != PistonState.RETRACTED) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (hitResult.getDirection() != direction) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (((MechanicalPistonBlock)state.getBlock()).isSticky) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            Vec3 vec = hitResult.getLocation();
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        AllSoundEvents.SLIME_ADDED.playOnServer(level, (Vec3i)pos, 0.5f, 1.0f);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)AllBlocks.STICKY_MECHANICAL_PISTON.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.getValue((Property)AXIS_ALONG_FIRST_COORDINATE))));
        return InteractionResult.SUCCESS;
    }

    @Override
    public void neighborUpdate(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos fromPos, boolean isMoving) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (!fromPos.equals((Object)pos.relative(direction.getOpposite()))) {
            return;
        }
        if (!world.isClientSide() && !world.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState pole = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (!pole.is((Block)AllBlocks.PISTON_EXTENSION_POLE)) {
            if (pole.is(Blocks.AIR)) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                    Direction movementOppositeDirection;
                    if (be.running) {
                        return;
                    }
                    float speed = be.getSpeed();
                    if (speed == 0.0f) {
                        return;
                    }
                    Direction positive = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.getAxis());
                    Direction direction2 = movementOppositeDirection = speed > 0.0f ^ direction.getAxis() != Direction.Axis.Z ? positive.getOpposite() : positive;
                    if (movementOppositeDirection == direction) {
                        be.assembleNextTick = true;
                    }
                });
            }
            return;
        }
        if (((Direction)pole.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis() != direction.getAxis()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            float speed;
            if (!be.running && (speed = be.getSpeed()) != 0.0f) {
                Direction movementDirection;
                Direction positive = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.getAxis());
                Direction direction2 = movementDirection = speed > 0.0f ^ direction.getAxis() != Direction.Axis.Z ? positive : positive.getOpposite();
                if (movementDirection == direction) {
                    be.assembleNextTick = true;
                }
            }
            if (be.lastException == null) {
                return;
            }
            be.lastException = null;
            be.sendData();
        });
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (state.getValue(STATE) != PistonState.RETRACTED) {
            return InteractionResult.PASS;
        }
        return super.onWrenched(state, context);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockState block;
        BlockPos currentPos;
        int offset;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos pistonHead = null;
        BlockPos pistonBase = pos;
        boolean dropBlocks = player == null || !player.isCreative();
        Integer maxPoles = MechanicalPistonBlock.maxAllowedPistonPoles();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.relative(direction, offset);
            block = worldIn.getBlockState(currentPos);
            if (MechanicalPistonBlock.isExtensionPole(block) && direction.getAxis() == ((Direction)block.getValue((Property)BlockStateProperties.FACING)).getAxis()) continue;
            if (!MechanicalPistonBlock.isPistonHead(block) || block.getValue((Property)BlockStateProperties.FACING) != direction) break;
            pistonHead = currentPos;
            break;
        }
        if (pistonHead != null && pistonBase != null) {
            BlockPos.betweenClosedStream((BlockPos)pistonBase, pistonHead).filter(p -> !p.equals((Object)pos)).forEach(p -> worldIn.destroyBlock(p, dropBlocks));
        }
        for (offset = 1; offset < maxPoles && MechanicalPistonBlock.isExtensionPole(block = worldIn.getBlockState(currentPos = pos.relative(direction.getOpposite(), offset))) && direction.getAxis() == ((Direction)block.getValue((Property)BlockStateProperties.FACING)).getAxis(); ++offset) {
            worldIn.destroyBlock(currentPos, dropBlocks);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public static int maxAllowedPistonPoles() {
        return (Integer)AllConfigs.server().kinetics.maxPistonPoles.get();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(STATE) == PistonState.EXTENDED) {
            return AllShapes.MECHANICAL_PISTON_EXTENDED.get((Direction)state.getValue((Property)FACING));
        }
        if (state.getValue(STATE) == PistonState.MOVING) {
            return AllShapes.MECHANICAL_PISTON.get((Direction)state.getValue((Property)FACING));
        }
        return Shapes.block();
    }

    @Override
    public Class<MechanicalPistonBlockEntity> getBlockEntityClass() {
        return MechanicalPistonBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends MechanicalPistonBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.MECHANICAL_PISTON;
    }

    public static boolean isPiston(BlockState state) {
        return state.is((Block)AllBlocks.MECHANICAL_PISTON) || MechanicalPistonBlock.isStickyPiston(state);
    }

    public static boolean isStickyPiston(BlockState state) {
        return state.is((Block)AllBlocks.STICKY_MECHANICAL_PISTON);
    }

    public static boolean isExtensionPole(BlockState state) {
        return state.is((Block)AllBlocks.PISTON_EXTENSION_POLE);
    }

    public static boolean isPistonHead(BlockState state) {
        return state.is((Block)AllBlocks.MECHANICAL_PISTON_HEAD);
    }

    public static enum PistonState implements StringRepresentable
    {
        RETRACTED,
        MOVING,
        EXTENDED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

