/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.placard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.decoration.placard.PlacardBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class PlacardBlockEntity
extends SmartBlockEntity {
    ItemStack heldItem = ItemStack.EMPTY;
    int poweredTicks = 0;

    public PlacardBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.PLACARD, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        if (!this.heldItem.isEmpty()) {
            Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)this.heldItem);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.poweredTicks == 0) {
            return;
        }
        --this.poweredTicks;
        if (this.poweredTicks > 0) {
            return;
        }
        BlockState blockState = this.getBlockState();
        this.level.setBlock(this.worldPosition, (BlockState)blockState.setValue((Property)PlacardBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
        PlacardBlock.updateNeighbours(blockState, this.level, this.worldPosition);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
        this.notifyUpdate();
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putInt("PoweredTicks", this.poweredTicks);
        if (!this.heldItem.isEmpty()) {
            view.store("Item", ItemStack.CODEC, (Object)this.heldItem);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        int prevTicks = this.poweredTicks;
        this.poweredTicks = view.getIntOr("PoweredTicks", 0);
        this.heldItem = view.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        super.read(view, clientPacket);
        if (clientPacket && prevTicks < this.poweredTicks) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.PLACARD)) {
            return;
        }
        DustParticleOptions pParticleData = new DustParticleOptions(0xFF3300, 1.0f);
        Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)PlacardBlock.connectedDirection(blockState).getUnitVec3i());
        Vec3 offset = VecHelper.axisAlingedPlaneOf(normal);
        for (int i = 0; i < 10; ++i) {
            Vec3 v = VecHelper.offsetRandomly(Vec3.ZERO, this.level.random, 0.5f).multiply(offset).normalize().scale((double)0.45f).add(normal.scale((double)-0.45f)).add(centerOf);
            this.level.addParticle((ParticleOptions)pParticleData, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }
}

