/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class WhistleBlockEntity
extends SmartBlockEntity {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public int pitch;

    public WhistleBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.STEAM_WHISTLE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_WHISTLE);
    }

    public void updatePitch() {
        BlockState blockState;
        int newPitch;
        BlockPos currentPos = this.worldPosition.above();
        for (newPitch = 0; newPitch <= 24 && (blockState = this.level.getBlockState(currentPos)).is((Block)AllBlocks.STEAM_WHISTLE_EXTENSION); newPitch += 2) {
            if (blockState.getValue(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                ++newPitch;
                break;
            }
            currentPos = currentPos.above();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide() && this.isPowered()) {
            this.award(AllAdvancements.STEAM_WHISTLE);
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putInt("Pitch", this.pitch);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.pitch = view.getIntOr("Pitch", 0);
        super.read(view, clientPacket);
    }

    public boolean isPowered() {
        return (Boolean)this.getBlockState().getValueOrElse((Property)WhistleBlock.POWERED, (Comparable)Boolean.valueOf(false));
    }

    public WhistleBlock.WhistleSize getOctave() {
        return (WhistleBlock.WhistleSize)((Object)this.getBlockState().getValueOrElse(WhistleBlock.SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)));
    }

    public int getPitchId() {
        return this.pitch + 100 * ((WhistleBlock.WhistleSize)((Object)this.getBlockState().getValueOrElse(WhistleBlock.SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)))).ordinal();
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.isRemoved()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.level.getBlockEntity(this.worldPosition.relative(facing = WhistleBlock.getAttachedDirection(this.getBlockState())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

