/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.extendoGrip;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public class ExtendoGripItem
extends Item {
    public static final AttributeModifier singleRangeAttributeModifier = new AttributeModifier(Identifier.fromNamespaceAndPath((String)"create", (String)"single_range_attribute_modifier"), 3.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier doubleRangeAttributeModifier = new AttributeModifier(Identifier.fromNamespaceAndPath((String)"create", (String)"double_range_attribute_modifier"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier attackKnockbackAttributeModifier = new AttributeModifier(Identifier.fromNamespaceAndPath((String)"create", (String)"attack_knockback_attribute_modifier"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    public static final ItemAttributeModifiers rangeModifier = ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, singleRangeAttributeModifier, EquipmentSlotGroup.HAND).add(Attributes.ENTITY_INTERACTION_RANGE, singleRangeAttributeModifier, EquipmentSlotGroup.HAND).add(Attributes.ATTACK_KNOCKBACK, attackKnockbackAttributeModifier, EquipmentSlotGroup.HAND).build();
    public static final ItemAttributeModifiers doubleRangeModifier = ItemAttributeModifiers.builder().add(Attributes.BLOCK_INTERACTION_RANGE, doubleRangeAttributeModifier, EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, doubleRangeAttributeModifier, EquipmentSlotGroup.MAINHAND).build();

    public ExtendoGripItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, ServerLevel world, Entity entity, @Nullable EquipmentSlot slot) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (slot == EquipmentSlot.MAINHAND) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getItemBySlot(EquipmentSlot.OFFHAND).is((Item)AllItems.EXTENDO_GRIP)) {
                if (modifiers != doubleRangeModifier) {
                    stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)doubleRangeModifier);
                    ((ItemStack)livingEntity.lastEquipmentItems.get(slot)).remove(DataComponents.ATTRIBUTE_MODIFIERS);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        AllAdvancements.EXTENDO_GRIP_DUAL.trigger(serverPlayer);
                    }
                }
            } else {
                ExtendoGripItem.applyAttributeModifiers(stack, modifiers, rangeModifier);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    AllAdvancements.EXTENDO_GRIP.trigger(serverPlayer);
                }
            }
        } else {
            ExtendoGripItem.applyAttributeModifiers(stack, modifiers, rangeModifier);
        }
    }

    private static void applyAttributeModifiers(ItemStack stack, ItemAttributeModifiers oldComponent, ItemAttributeModifiers newComponent) {
        if (oldComponent != newComponent) {
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)newComponent);
        }
    }

    public static void postDamageEntity(Player player) {
        if (ExtendoGripItem.damageMainHand(player, player.getMainHandItem())) {
            return;
        }
        ExtendoGripItem.damageOffHand(player);
    }

    public static void postPlace(Player player) {
        ExtendoGripItem.damageOffHand(player);
    }

    public static void postMine(Player player, ItemStack stack) {
        if (ExtendoGripItem.damageMainHand(player, stack)) {
            return;
        }
        ExtendoGripItem.damageOffHand(player);
    }

    private static boolean damageMainHand(Player player, ItemStack stack) {
        if (stack.is((Item)AllItems.EXTENDO_GRIP)) {
            ExtendoGripItem.damage(player, EquipmentSlot.MAINHAND, stack);
            return true;
        }
        return false;
    }

    private static void damageOffHand(Player player) {
        ItemStack stack = player.getOffhandItem();
        if (stack.is((Item)AllItems.EXTENDO_GRIP)) {
            ExtendoGripItem.damage(player, EquipmentSlot.OFFHAND, stack);
        }
    }

    private static void damage(Player player, EquipmentSlot slot, ItemStack stack) {
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, ExtendoGripItem.maxUses())) {
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible(stack, ExtendoGripItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth(stack, ExtendoGripItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor(stack, ExtendoGripItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxExtendoGripActions.get();
    }

    public static boolean shouldInteraction(Player player, InteractionHand hand, ItemStack stack) {
        if (stack.is((Item)AllItems.EXTENDO_GRIP)) {
            return true;
        }
        return player.getItemBySlot(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND).is((Item)AllItems.EXTENDO_GRIP);
    }
}

