/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ToolboxBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IBE<ToolboxBlockEntity>,
ItemInventoryProvider<ToolboxBlockEntity> {
    protected final DyeColor color;
    public static final MapCodec<ToolboxBlock> CODEC = ToolboxBlock.simpleCodec(p -> new ToolboxBlock((BlockBehaviour.Properties)p, DyeColor.WHITE));

    public ToolboxBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, ToolboxBlockEntity blockEntity, Direction context) {
        return blockEntity.inventory;
    }

    public static Function<BlockBehaviour.Properties, ToolboxBlock> dyed(DyeColor color) {
        return settings -> new ToolboxBlock((BlockBehaviour.Properties)settings, color);
    }

    public static ToolboxBlock getColorBlock(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AllBlocks.WHITE_TOOLBOX;
            case DyeColor.ORANGE -> AllBlocks.ORANGE_TOOLBOX;
            case DyeColor.MAGENTA -> AllBlocks.MAGENTA_TOOLBOX;
            case DyeColor.LIGHT_BLUE -> AllBlocks.LIGHT_BLUE_TOOLBOX;
            case DyeColor.YELLOW -> AllBlocks.YELLOW_TOOLBOX;
            case DyeColor.LIME -> AllBlocks.LIME_TOOLBOX;
            case DyeColor.PINK -> AllBlocks.PINK_TOOLBOX;
            case DyeColor.GRAY -> AllBlocks.GRAY_TOOLBOX;
            case DyeColor.LIGHT_GRAY -> AllBlocks.LIGHT_GRAY_TOOLBOX;
            case DyeColor.CYAN -> AllBlocks.CYAN_TOOLBOX;
            case DyeColor.PURPLE -> AllBlocks.PURPLE_TOOLBOX;
            case DyeColor.BLUE -> AllBlocks.BLUE_TOOLBOX;
            case DyeColor.BROWN -> AllBlocks.BROWN_TOOLBOX;
            case DyeColor.GREEN -> AllBlocks.GREEN_TOOLBOX;
            case DyeColor.RED -> AllBlocks.RED_TOOLBOX;
            case DyeColor.BLACK -> AllBlocks.BLACK_TOOLBOX;
        };
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.WATERLOGGED}).add(new Property[]{FACING}));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            be.readInventory((ToolboxInventory)stack.get(AllDataComponents.TOOLBOX_INVENTORY));
            if (stack.has(AllDataComponents.TOOLBOX_UUID)) {
                be.setUniqueId((UUID)stack.get(AllDataComponents.TOOLBOX_UUID));
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.setCustomName(stack.getHoverName());
            }
        });
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (FakePlayerHandler.has((Entity)player)) {
            return;
        }
        if (world.isClientSide()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, ToolboxBlockEntity::unequipTracked);
        if (world instanceof ServerLevel) {
            ItemStack cloneItemStack = this.getCloneItemStack((LevelReader)world, pos, state, true);
            this.withBlockEntityDo((BlockGetter)world, pos, i -> cloneItemStack.applyComponents(i.collectComponents()));
            world.destroyBlock(pos, false);
            if (world.getBlockState(pos) != state) {
                player.getInventory().placeItemBackInInventory(cloneItemStack);
            }
        }
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack item = new ItemStack((ItemLike)this);
        Optional blockEntityOptional = this.getBlockEntityOptional((BlockGetter)world, pos);
        blockEntityOptional.map(tb -> (ToolboxInventory)item.set(AllDataComponents.TOOLBOX_INVENTORY, (Object)tb.inventory));
        blockEntityOptional.map(ToolboxBlockEntity::getUniqueId).ifPresent(uid -> item.set(AllDataComponents.TOOLBOX_UUID, uid));
        blockEntityOptional.map(ToolboxBlockEntity::getCustomName).ifPresent(name -> item.set(DataComponents.CUSTOM_NAME, name));
        return item;
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighbourPos, BlockState neighbourState, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AllShapes.TOOLBOX.get((Direction)state.getValue((Property)FACING));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null || player.isCrouching()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        DyeColor color = AllItemTags.getDyeColor(stack);
        if (color != null && color != this.color) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties(state, ToolboxBlock.getColorBlock(color).defaultBlockState());
            level.setBlockAndUpdate(pos, newState);
            return InteractionResult.SUCCESS;
        }
        if (FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, toolbox -> toolbox.openHandledScreen((ServerPlayer)player));
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    @Override
    public Class<ToolboxBlockEntity> getBlockEntityClass() {
        return ToolboxBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ToolboxBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TOOLBOX;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos, Direction direction) {
        return ItemHelper.calcRedstoneFromBlockEntity(this, pLevel, pPos);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

