/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.toolbox.ToolboxSlot;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ToolboxMenu
extends MenuBase<ToolboxBlockEntity> {
    public boolean renderPass;

    public ToolboxMenu(int id, Inventory inv, ToolboxBlockEntity be) {
        super(AllMenuTypes.TOOLBOX, id, inv, be);
        BlockEntityBehaviour.get(be, AnimatedContainerBehaviour.TYPE).startOpen(this.player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        boolean success;
        Slot clickedSlot = this.getSlot(index);
        ItemStack stack = clickedSlot.getItem();
        int size = ((ToolboxBlockEntity)this.contentHolder).inventory.getContainerSize();
        if (index < size) {
            if ((stack = this.settle(stack, index)).isEmpty()) {
                return stack;
            }
            success = !this.moveItemStackTo(stack, size, this.slots.size(), true);
            ((ToolboxBlockEntity)this.contentHolder).inventory.setChanged();
        } else {
            if (stack.isEmpty()) {
                return stack;
            }
            success = !this.moveItemStackTo(stack, 0, size, false);
        }
        return success ? ItemStack.EMPTY : stack;
    }

    public ItemStack settle(ItemStack stack, int index) {
        ItemStack extract;
        int space;
        int count = stack.getCount();
        if (count == 0) {
            ItemStack filter = (ItemStack)((ToolboxBlockEntity)this.contentHolder).inventory.filters.get(index / 4);
            if (filter.isEmpty()) {
                return stack;
            }
            space = filter.getMaxStackSize();
        } else {
            space = stack.getMaxStackSize() - count;
        }
        if (space != 0 && !(extract = ((ToolboxBlockEntity)this.contentHolder).inventory.takeFromCompartment(space, index + 1, index + 4 - 1)).isEmpty()) {
            if (count == 0) {
                stack = extract;
                ((ToolboxBlockEntity)this.contentHolder).inventory.setItem(index, stack);
            } else {
                stack.setCount(count + extract.getCount());
            }
        }
        return stack;
    }

    @Override
    protected void initAndReadInventory(ToolboxBlockEntity contentHolder) {
    }

    public void clicked(int index, int flags, ClickType type, Player player) {
        if (index >= 0 && index < ((ToolboxBlockEntity)this.contentHolder).inventory.getContainerSize()) {
            int subIndex;
            ItemStack itemInClickedSlot = this.getSlot(index).getItem();
            ItemStack carried = this.getCarried();
            if (type == ClickType.PICKUP && !carried.isEmpty() && !itemInClickedSlot.isEmpty() && ToolboxInventory.canItemsShareCompartment(itemInClickedSlot, carried) && (subIndex = index % 4) != 3) {
                this.clicked(index - subIndex + 4 - 1, flags, type, player);
                return;
            }
            if (type == ClickType.PICKUP && carried.isEmpty() && this.settle(itemInClickedSlot, index).isEmpty() && !player.level().isClientSide()) {
                ((ToolboxBlockEntity)this.contentHolder).inventory.filters.set(index / 4, (Object)ItemStack.EMPTY);
                ((ToolboxBlockEntity)this.contentHolder).sendData();
            }
        }
        super.clicked(index, flags, type, player);
    }

    public boolean canDragTo(Slot slot) {
        return slot.index > ((ToolboxBlockEntity)this.contentHolder).inventory.getContainerSize();
    }

    public ItemStack getFilter(int compartment) {
        return (ItemStack)((ToolboxBlockEntity)this.contentHolder).inventory.filters.get(compartment);
    }

    public int totalCountInCompartment(int compartment) {
        int count = 0;
        int baseSlot = compartment * 4;
        for (int i = 0; i < 4; ++i) {
            count += this.getSlot(baseSlot + i).getItem().getCount();
        }
        return count;
    }

    @Override
    protected void addSlots() {
        ToolboxInventory inventory = ((ToolboxBlockEntity)this.contentHolder).inventory;
        int x = 79;
        int y = 37;
        int[] xOffsets = new int[]{x, x + 33, x + 66, x + 66 + 6, x + 66, x + 33, x, x - 6};
        int[] yOffsets = new int[]{y, y - 6, y, y + 33, y + 66, y + 66 + 6, y + 66, y + 33};
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            this.addSlot(new ToolboxSlot(this, inventory, baseIndex, xOffsets[compartment], yOffsets[compartment], true));
            for (int i = 1; i < 4; ++i) {
                this.addSlot(new ToolboxSlot(this, inventory, baseIndex + i, -10000, -10000, false));
            }
        }
        this.addPlayerSlots(8, 165);
    }

    @Override
    protected void saveData(ToolboxBlockEntity contentHolder) {
    }

    @Override
    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!playerIn.level().isClientSide()) {
            BlockEntityBehaviour.get((BlockEntity)this.contentHolder, AnimatedContainerBehaviour.TYPE).stopOpen(playerIn);
        }
    }
}

