/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.api.effect.OpenPipeEffectHandler;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FlowSource;
import com.zurrtum.create.content.fluids.FluidReactions;
import com.zurrtum.create.content.fluids.pipes.VanillaFluidTargets;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Util;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class OpenEndedPipe
extends FlowSource {
    private static final Function<BlockPos, Codec<OpenEndedPipe>> CODEC = Util.memoize(pos -> RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.OPTIONAL_CODEC.fieldOf("Fluid").forGetter(i -> i.fluidHandler.stack), (App)Codec.BOOL.fieldOf("Pulling").forGetter(i -> i.wasPulling), (App)Direction.CODEC.fieldOf("Direction").forGetter(i -> i.location.getFace())).apply((Applicative)instance, (stack, wasPulling, direction) -> new OpenEndedPipe((FluidStack)stack, (boolean)wasPulling, (BlockPos)pos, (Direction)direction))));
    private Level world;
    private final BlockPos pos;
    private AABB aoe;
    private final OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private final BlockPos outputPos;
    private boolean wasPulling;

    public static Codec<OpenEndedPipe> codec(BlockPos pos) {
        return CODEC.apply(pos);
    }

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new AABB(this.outputPos).expandTowards(0.0, -1.0, 0.0);
        if (face.getFace() == Direction.DOWN) {
            this.aoe = this.aoe.expandTowards(0.0, -1.0, 0.0);
        }
    }

    private OpenEndedPipe(FluidStack stack, boolean wasPulling, BlockPos pos, Direction direction) {
        this(new BlockFace(pos, direction));
        this.fluidHandler.stack = stack;
        this.wasPulling = wasPulling;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getOutputPos() {
        return this.outputPos;
    }

    public AABB getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(Level world, BlockEntity networkBE) {
        this.world = world;
    }

    @Override
    @Nullable
    public FluidInventory provideHandler() {
        return this.fluidHandler;
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        if (this.world == null) {
            return FluidStack.EMPTY;
        }
        if (!this.world.isLoaded(this.outputPos)) {
            return FluidStack.EMPTY;
        }
        BlockState state = this.world.getBlockState(this.outputPos);
        FluidState fluidState = state.getFluidState();
        boolean waterlog = state.hasProperty((Property)BlockStateProperties.WATERLOGGED);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.hasProperty((Property)BlockStateProperties.LEVEL_HONEY) && drainBlock.getFluid() == AllFluids.HONEY) {
                AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.HONEY_DRAIN);
            }
            return drainBlock;
        }
        if (!waterlog && !state.canBeReplaced()) {
            return FluidStack.EMPTY;
        }
        if (fluidState.isEmpty() || !fluidState.isSource()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(fluidState.getType(), 81000);
        if (simulate) {
            return stack;
        }
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        if (waterlog) {
            this.world.setBlock(this.outputPos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            this.world.scheduleTick(this.outputPos, (Fluid)Fluids.WATER, 1);
        } else {
            BlockState newState = (BlockState)fluidState.createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(14));
            FluidState newFluidState = newState.getFluidState();
            Fluid fluid = newFluidState.getType();
            if (fluid instanceof FlowingFluid) {
                ServerLevel serverWorld;
                FluidState potentiallyFilled;
                FlowingFluid flowing = (FlowingFluid)fluid;
                fluid = this.world;
                if (fluid instanceof ServerLevel && (potentiallyFilled = flowing.getNewLiquid(serverWorld = (ServerLevel)fluid, this.outputPos, newState)).equals((Object)fluidState)) {
                    return stack;
                }
            }
            this.world.setBlock(this.outputPos, newState, 3);
        }
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.isLoaded(this.outputPos)) {
            return false;
        }
        BlockState state = this.world.getBlockState(this.outputPos);
        FluidState fluidState = state.getFluidState();
        boolean waterlog = state.hasProperty((Property)BlockStateProperties.WATERLOGGED);
        if (!waterlog && !state.canBeReplaced()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!(fluid.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid())) {
            return true;
        }
        if (!fluidState.isEmpty() && FluidHelper.convertToStill(fluidState.getType()) != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.isSource()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != Fluids.WATER) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (!((Boolean)AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        if (((Boolean)this.world.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, this.outputPos)).booleanValue() && FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.WATER)) {
            int i = this.outputPos.getX();
            int j = this.outputPos.getY();
            int k = this.outputPos.getZ();
            this.world.playSound(null, (double)i, (double)j, (double)k, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (this.world.random.nextFloat() - this.world.random.nextFloat()) * 0.8f);
            return true;
        }
        if (waterlog) {
            this.world.setBlock(this.outputPos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            this.world.scheduleTick(this.outputPos, (Fluid)Fluids.WATER, 1);
            return true;
        }
        this.world.setBlock(this.outputPos, fluid.getFluid().defaultFluidState().createLegacyBlock(), 3);
        return true;
    }

    private class OpenEndFluidHandler
    implements SidedFluidInventory {
        private static final Optional<Integer> MAX = Optional.of(81000);
        private static final int[] SLOTS = new int[]{0, 1};
        private FluidStack stack = FluidStack.EMPTY;
        private int previousAmount = 0;

        private OpenEndFluidHandler() {
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, MAX);
        }

        @Override
        public int getMaxAmountPerStack() {
            return 81000;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int[] getAvailableSlots(Direction side) {
            return SLOTS;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot > 1) {
                return FluidStack.EMPTY;
            }
            if (slot == 0) {
                return this.stack;
            }
            if (this.stack == FluidStack.EMPTY) {
                this.stack = OpenEndedPipe.this.removeFluidFromSpace(false);
                if (!this.stack.isEmpty()) {
                    this.setMaxSize(this.stack, MAX);
                }
                return this.stack;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getMaxAmount(FluidStack stack) {
            OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(stack.getFluid());
            if (effectHandler != null && !FluidHelper.hasBlockState(stack.getFluid())) {
                return 81;
            }
            return SidedFluidInventory.super.getMaxAmount(stack);
        }

        @Override
        public boolean canInsert(int slot, FluidStack resource, @Nullable Direction dir) {
            if (slot != 0 || !OpenEndedPipe.this.provideFluidToSpace(resource, true)) {
                return false;
            }
            if (!this.stack.isEmpty() && !this.matches(this.stack, resource)) {
                this.stack = FluidStack.EMPTY;
            }
            return true;
        }

        @Override
        public boolean canExtract(int slot, FluidStack stack, Direction dir) {
            return OpenEndedPipe.this.world != null && OpenEndedPipe.this.world.isLoaded(OpenEndedPipe.this.outputPos);
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot != 0) {
                return;
            }
            if (stack != FluidStack.EMPTY) {
                this.setMaxSize(stack, MAX);
            }
            this.stack = stack;
        }

        @Override
        public void markDirty() {
            int amount = this.stack.getAmount();
            if (amount > this.previousAmount) {
                Fluid fluid = this.stack.getFluid();
                OpenPipeEffectHandler effectHandler = OpenPipeEffectHandler.REGISTRY.get(fluid);
                if (effectHandler != null) {
                    effectHandler.apply(OpenEndedPipe.this.world, OpenEndedPipe.this.aoe, this.stack);
                }
                if ((this.stack.getAmount() == 81000 || !FluidHelper.hasBlockState(fluid)) && OpenEndedPipe.this.provideFluidToSpace(this.stack, false)) {
                    this.stack = FluidStack.EMPTY;
                }
                OpenEndedPipe.this.wasPulling = false;
            } else if (amount < this.previousAmount) {
                OpenEndedPipe.this.wasPulling = true;
            }
            this.previousAmount = this.stack.getAmount();
        }
    }
}

