/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.hosePulley;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.zurrtum.create.content.fluids.transfer.FluidFillingBehaviour;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class HosePulleyBlockEntity
extends KineticBlockEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    private FluidDrainingBehaviour drainer;
    private FluidFillingBehaviour filler;
    public HosePulleyFluidHandler handler = new HosePulleyFluidHandler(this, this.filler, this.drainer, () -> pos.below((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    public boolean infinite;

    public HosePulleyBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.HOSE_PULLEY, pos, state);
    }

    @Override
    public void sendData() {
        this.infinite = this.filler.isInfinite() || this.drainer.isInfinite();
        super.sendData();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.drainer = new FluidDrainingBehaviour(this);
        this.filler = new FluidFillingBehaviour(this);
        behaviours.add(this.drainer);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.HOSE_PULLEY, AllAdvancements.HOSE_PULLEY_LAVA);
    }

    protected void onTankContentsChanged(FluidStack contents) {
        this.setChanged();
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue(Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.level.getBlockState(this.worldPosition.below((int)Math.ceil(newOffset))).canBeReplaced()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.drainer.reset();
                this.filler.reset();
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.level.getBlockState(this.worldPosition.below((int)Math.ceil(newOffset))).canBeReplaced()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue(newOffset);
        this.invalidateRenderBoundingBox();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.level.getBlockState(this.worldPosition.below(ceil)).canBeReplaced()) {
            this.isMoving = true;
            this.drainer.reset();
            this.filler.reset();
            return;
        }
        this.sendData();
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        if (clientPacket) {
            this.offset.forceNextSync();
        }
        this.offset.write(view.child("Offset"));
        this.handler.write(view);
        super.write(view, clientPacket);
        if (clientPacket) {
            view.putBoolean("Infinite", this.infinite);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.offset.read(view.childOrEmpty("Offset"), clientPacket);
        this.handler.read(view);
        super.read(view, clientPacket);
        if (clientPacket) {
            this.infinite = view.getBooleanOr("Infinite", false);
        }
    }

    public float getMovementSpeed() {
        float movementSpeed = HosePulleyBlockEntity.convertToLinear(this.getSpeed());
        if (this.level.isClientSide()) {
            movementSpeed *= AllClientHandle.INSTANCE.getServerSpeed();
        }
        return movementSpeed;
    }

    public float getInterpolatedOffset(float pt) {
        return Math.max(this.offset.getValue(pt), 0.1875f);
    }
}

