/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.hosePulley;

import com.zurrtum.create.content.fluids.hosePulley.HosePulleyBlock;
import com.zurrtum.create.content.fluids.hosePulley.HosePulleyBlockEntity;
import com.zurrtum.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.zurrtum.create.content.fluids.transfer.FluidFillingBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class HosePulleyFluidHandler
implements SidedFluidInventory {
    private static final int HALF_BUCKET = 40500;
    private static final int CAPACITY = 121500;
    private static final Optional<Integer> MAX = Optional.of(121500);
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] EMPTY_SLOTS = new int[0];
    private final FluidFillingBehaviour filler;
    private final FluidDrainingBehaviour drainer;
    private final Supplier<BlockPos> rootPosGetter;
    private final Supplier<Boolean> predicate;
    private final HosePulleyBlockEntity be;
    private FluidStack stack = FluidStack.EMPTY;
    private int previousAmount = 0;

    public HosePulleyFluidHandler(HosePulleyBlockEntity be, FluidFillingBehaviour filler, FluidDrainingBehaviour drainer, Supplier<BlockPos> rootPosGetter, Supplier<Boolean> predicate) {
        this.be = be;
        this.filler = filler;
        this.drainer = drainer;
        this.rootPosGetter = rootPosGetter;
        this.predicate = predicate;
    }

    @Override
    public int[] getAvailableSlots(@Nullable Direction side) {
        if (HosePulleyBlock.hasPipeTowards((LevelReader)this.be.getLevel(), this.be.getBlockPos(), this.be.getBlockState(), side)) {
            return SLOTS;
        }
        return EMPTY_SLOTS;
    }

    @Override
    public boolean canInsert(int slot, FluidStack stack, @Nullable Direction dir) {
        if (slot != 0 || !FluidHelper.hasBlockState(stack.getFluid())) {
            return false;
        }
        return this.stack.getAmount() < 81000 || this.predicate.get() != false && this.filler.tryDeposit(stack.getFluid(), this.rootPosGetter.get(), true);
    }

    @Override
    public boolean canExtract(int slot, FluidStack stack, Direction dir) {
        if (slot == 1) {
            return this.predicate.get();
        }
        return true;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public FluidStack onExtract(FluidStack stack) {
        return this.removeMaxSize(stack, MAX);
    }

    @Override
    public int getMaxAmountPerStack() {
        return 121500;
    }

    @Override
    public FluidStack getStack(int slot) {
        FluidStack stack;
        if (slot > 1) {
            return FluidStack.EMPTY;
        }
        if (slot == 0) {
            return this.stack;
        }
        int amount = this.stack.getAmount();
        if (amount <= 40500 && this.drainer.pullNext(this.rootPosGetter.get(), true) && !(stack = this.drainer.getDrainableFluid(this.rootPosGetter.get())).isEmpty() && (amount == 0 || this.matches(this.stack, stack)) && this.drainer.pullNext(this.rootPosGetter.get(), false)) {
            this.filler.counterpartActed();
            this.setMaxSize(stack, MAX);
            if (amount > 0) {
                stack.setAmount(amount + 81000);
            }
            this.stack = stack;
            return this.stack;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot != 0) {
            return;
        }
        if (stack != FluidStack.EMPTY) {
            this.setMaxSize(stack, MAX);
        }
        this.stack = stack;
    }

    @Override
    public void markDirty() {
        int amount = this.stack.getAmount();
        if (amount > this.previousAmount) {
            if (amount >= 81000 && this.predicate.get().booleanValue() && this.filler.tryDeposit(this.stack.getFluid(), this.rootPosGetter.get(), false)) {
                this.drainer.counterpartActed();
                if ((amount -= 81000) == 0) {
                    this.stack = FluidStack.EMPTY;
                } else {
                    this.stack.setAmount(amount);
                }
            }
            this.be.onTankContentsChanged(this.stack);
        } else if (amount < this.previousAmount) {
            this.be.onTankContentsChanged(this.stack);
        }
        this.previousAmount = this.stack.getAmount();
    }

    public void write(ValueOutput view) {
        if (!this.stack.isEmpty()) {
            view.store("Fluid", FluidStack.CODEC, (Object)this.stack);
        }
    }

    public void read(ValueInput view) {
        this.stack = view.read("Fluid", FluidStack.CODEC).orElse(FluidStack.EMPTY);
    }
}

