/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt.transport;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;

public class TransportedItemStack
implements Comparable<TransportedItemStack> {
    public static final Codec<TransportedItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("Item").forGetter(i -> i.stack), (App)Codec.FLOAT.fieldOf("Pos").forGetter(i -> Float.valueOf(i.beltPosition)), (App)Codec.FLOAT.fieldOf("PrevPos").forGetter(i -> Float.valueOf(i.prevBeltPosition)), (App)Codec.FLOAT.fieldOf("Offset").forGetter(i -> Float.valueOf(i.sideOffset)), (App)Codec.FLOAT.fieldOf("PrevOffset").forGetter(i -> Float.valueOf(i.prevSideOffset)), (App)Codec.INT.fieldOf("InSegment").forGetter(i -> i.insertedAt), (App)Codec.INT.fieldOf("Angle").forGetter(i -> i.angle), (App)Direction.CODEC.fieldOf("InDirection").forGetter(i -> i.insertedFrom), (App)CreateRegistries.FAN_PROCESSING_TYPE.byNameCodec().optionalFieldOf("FanProcessingType").forGetter(i -> Optional.ofNullable(i.processedBy)), (App)Codec.INT.optionalFieldOf("FanProcessingTime", (Object)0).forGetter(i -> i.processingTime), (App)Codec.BOOL.fieldOf("Locked").forGetter(i -> i.locked), (App)Codec.BOOL.fieldOf("LockedExternally").forGetter(i -> i.lockedExternally)).apply((Applicative)instance, TransportedItemStack::new));
    private static final Random R = new Random();
    public ItemStack stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public Direction insertedFrom;
    public boolean locked;
    public boolean lockedExternally;
    public float prevBeltPosition;
    public float prevSideOffset;
    public FanProcessingType processedBy;
    public int processingTime;

    public TransportedItemStack(ItemStack stack) {
        boolean centered;
        this.stack = stack;
        this.angle = PackageItem.isPackage(stack) ? R.nextInt(4) * 90 + R.nextInt(20) - 10 : ((centered = BeltHelper.isItemUpright(stack)) ? 180 : R.nextInt(360));
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = Direction.UP;
    }

    private TransportedItemStack(ItemStack stack, float beltPosition, float prevBeltPosition, float sideOffset, float prevSideOffset, int insertedAt, int angle, Direction insertedFrom, Optional<FanProcessingType> processedBy, int processingTime, boolean locked, boolean lockedExternally) {
        this.stack = stack;
        this.beltPosition = beltPosition;
        this.prevBeltPosition = prevBeltPosition;
        this.sideOffset = sideOffset;
        this.prevSideOffset = prevSideOffset;
        this.insertedAt = insertedAt;
        this.angle = angle;
        this.insertedFrom = insertedFrom;
        this.locked = locked;
        this.lockedExternally = lockedExternally;
        this.processedBy = processedBy.orElse(null);
        this.processingTime = processingTime;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return this.beltPosition < o.beltPosition ? 1 : (this.beltPosition > o.beltPosition ? -1 : 0);
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(this.stack.copy());
        copy.beltPosition = this.beltPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevBeltPosition = this.prevBeltPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processedBy = this.processedBy;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.isEmpty()) {
            nbt.store("Item", ItemStack.CODEC, (Object)this.stack);
        }
        nbt.putFloat("Pos", this.beltPosition);
        nbt.putFloat("PrevPos", this.prevBeltPosition);
        nbt.putFloat("Offset", this.sideOffset);
        nbt.putFloat("PrevOffset", this.prevSideOffset);
        nbt.putInt("InSegment", this.insertedAt);
        nbt.putInt("Angle", this.angle);
        nbt.putInt("InDirection", this.insertedFrom.get3DDataValue());
        if (this.processedBy != null) {
            Identifier key = CreateRegistries.FAN_PROCESSING_TYPE.getKey((Object)this.processedBy);
            if (key == null) {
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(this.processedBy) + "!");
            }
            nbt.putString("FanProcessingType", key.toString());
            nbt.putInt("FanProcessingTime", this.processingTime);
        }
        if (this.locked) {
            nbt.putBoolean("Locked", this.locked);
        }
        if (this.lockedExternally) {
            nbt.putBoolean("LockedExternally", this.lockedExternally);
        }
        return nbt;
    }

    public static TransportedItemStack read(CompoundTag nbt, HolderLookup.Provider registries) {
        ItemStack source = nbt.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        TransportedItemStack stack = new TransportedItemStack(source);
        stack.beltPosition = nbt.getFloatOr("Pos", 0.0f);
        stack.prevBeltPosition = nbt.getFloatOr("PrevPos", 0.0f);
        stack.sideOffset = nbt.getFloatOr("Offset", 0.0f);
        stack.prevSideOffset = nbt.getFloatOr("PrevOffset", 0.0f);
        stack.insertedAt = nbt.getIntOr("InSegment", 0);
        stack.angle = nbt.getIntOr("Angle", 0);
        stack.insertedFrom = Direction.from3DDataValue((int)nbt.getIntOr("InDirection", 0));
        stack.locked = nbt.getBooleanOr("Locked", false);
        stack.lockedExternally = nbt.getBooleanOr("LockedExternally", false);
        if (nbt.contains("FanProcessingType")) {
            stack.processedBy = FanProcessingType.parse(nbt.getStringOr("FanProcessingType", ""));
            stack.processingTime = nbt.getIntOr("FanProcessingTime", 0);
        }
        return stack;
    }

    public void clearFanProcessingData() {
        this.processedBy = null;
        this.processingTime = 0;
    }
}

