/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FunnelMovementBehaviour
extends MovementBehaviour {
    private final boolean hasFilter;

    public static FunnelMovementBehaviour andesite() {
        return new FunnelMovementBehaviour(false);
    }

    public static FunnelMovementBehaviour brass() {
        return new FunnelMovementBehaviour(true);
    }

    private FunnelMovementBehaviour(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        Direction facing = FunnelBlock.getFunnelFacing(context.state);
        Vec3 vec = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
        if (facing != Direction.UP) {
            return vec.scale((Boolean)context.state.getValue((Property)FunnelBlock.EXTRACTING) != false ? 0.15 : 0.65);
        }
        return vec.scale(0.65);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        if (((Boolean)context.state.getValue((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            this.extract(context, pos);
        } else {
            this.succ(context, pos);
        }
    }

    private void extract(MovementContext context, BlockPos pos) {
        Level world = context.world;
        Vec3 entityPos = context.position;
        if (context.state.getValue((Property)FunnelBlock.FACING) != Direction.DOWN) {
            entityPos = entityPos.add(0.0, -0.5, 0.0);
        }
        if (!world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return;
        }
        if (!world.getEntitiesOfClass(ItemEntity.class, new AABB(BlockPos.containing((Position)entityPos))).isEmpty()) {
            return;
        }
        FilterItemStack filter = context.getFilterFromBE();
        int filterAmount = context.blockEntityData.getIntOr("FilterAmount", 0);
        boolean upTo = context.blockEntityData.getBooleanOr("UpTo", false);
        filterAmount = this.hasFilter ? filterAmount : 1;
        CombinedInvWrapper inventory = context.contraption.getStorage().getAllItems();
        ItemStack extract = upTo ? inventory.extract(s -> filter.test(world, (ItemStack)s), filterAmount) : inventory.preciseExtract(s -> filter.test(world, (ItemStack)s), filterAmount);
        if (extract.isEmpty()) {
            return;
        }
        if (world.isClientSide()) {
            return;
        }
        ItemEntity entity = new ItemEntity(world, entityPos.x, entityPos.y, entityPos.z, extract);
        entity.setDeltaMovement(Vec3.ZERO);
        entity.setPickUpDelay(5);
        world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.0625f, 0.1f);
        world.addFreshEntity((Entity)entity);
    }

    private void succ(MovementContext context, BlockPos pos) {
        Level world = context.world;
        List items = world.getEntities((Entity)null, new AABB(pos), e -> e instanceof ItemEntity || e instanceof PackageEntity);
        FilterItemStack filter = context.getFilterFromBE();
        for (Entity entity : items) {
            ItemStack toInsert;
            if (!entity.isAlive() || !filter.test(context.world, toInsert = ItemHelper.fromItemEntity(entity))) continue;
            CombinedInvWrapper inventory = context.contraption.getStorage().getAllItems();
            int count = toInsert.getCount();
            int insert = inventory.insertExist(toInsert);
            if (insert == count) {
                entity.discard();
                continue;
            }
            if (insert <= 0) continue;
            toInsert.setCount(count - insert);
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            item.setItem(toInsert);
        }
    }
}

