/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.PackagePortMenu;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class PackagePortBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public boolean acceptsPackages = true;
    public String addressFilter = "";
    public PackagePortTarget target;
    public PackagePortInventory inventory = new PackagePortInventory();
    protected AnimatedContainerBehaviour<PackagePortMenu> openTracker;

    public PackagePortBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isBackedUp() {
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (!this.inventory.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void filterChanged() {
        if (this.target != null) {
            this.target.deregister(this, (LevelAccessor)this.level, this.worldPosition);
            this.target.register(this, (LevelAccessor)this.level, this.worldPosition);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.target != null) {
            this.target.register(this, (LevelAccessor)this.level, this.worldPosition);
        }
    }

    public String getFilterString() {
        return this.acceptsPackages ? this.addressFilter : null;
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (this.target != null) {
            view.store("Target", PackagePortTarget.CODEC, (Object)this.target);
        }
        view.putString("AddressFilter", this.addressFilter);
        view.putBoolean("AcceptsPackages", this.acceptsPackages);
        this.inventory.write(view);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.inventory.read(view);
        PackagePortTarget prevTarget = this.target;
        this.target = view.read("Target", PackagePortTarget.CODEC).orElse(null);
        this.addressFilter = view.getStringOr("AddressFilter", "");
        this.acceptsPackages = view.getBooleanOr("AcceptsPackages", false);
        if (clientPacket && prevTarget != this.target) {
            this.invalidateRenderBoundingBox();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.deregister(this, (LevelAccessor)this.level, this.worldPosition);
        }
        super.destroy();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.inventory);
    }

    public void drop(ItemStack box) {
        if (box.isEmpty()) {
            return;
        }
        Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)box);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<PackagePortMenu>(this, PackagePortMenu.class);
        behaviours.add(this.openTracker);
        this.openTracker.onOpenChanged(this::onOpenChange);
    }

    protected abstract void onOpenChange(boolean var1);

    public InteractionResult use(Player player) {
        if (player == null || player.isCrouching()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        boolean clipboard = mainHandItem.is((Item)AllItems.CLIPBOARD);
        if (this.level.isClientSide()) {
            if (!clipboard) {
                this.onOpenedManually();
            }
            return InteractionResult.SUCCESS;
        }
        if (clipboard) {
            this.addAddressToClipboard(player, mainHandItem);
            return InteractionResult.SUCCESS;
        }
        this.openHandledScreen((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    protected void onOpenedManually() {
    }

    private void addAddressToClipboard(Player player, ItemStack mainHandItem) {
        if (this.addressFilter == null || this.addressFilter.isBlank()) {
            return;
        }
        ClipboardContent clipboard = (ClipboardContent)mainHandItem.getOrDefault(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY);
        List<List<ClipboardEntry>> list = ClipboardEntry.readAll(clipboard);
        for (List<ClipboardEntry> page : list) {
            for (ClipboardEntry entry : page) {
                String existing = entry.text.getString();
                if (!existing.equals("#" + this.addressFilter) && !existing.equals("# " + this.addressFilter)) continue;
                return;
            }
        }
        List<ClipboardEntry> page = null;
        for (List<ClipboardEntry> freePage : list) {
            if (freePage.size() > 11) continue;
            page = freePage;
            break;
        }
        if (page == null) {
            page = new ArrayList<ClipboardEntry>();
            list.add(page);
        }
        page.add(new ClipboardEntry(false, Component.literal((String)("#" + this.addressFilter))));
        player.displayClientMessage((Component)Component.translatable((String)"create.clipboard.address_added", (Object[])new Object[]{this.addressFilter}), true);
        clipboard = clipboard.setPages(list).setType(ClipboardType.WRITTEN);
        mainHandItem.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboard);
    }

    @Override
    public MenuBase<?> createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer, RegistryFriendlyByteBuf extraData) {
        extraData.writeBlockPos(this.worldPosition);
        return new PackagePortMenu(pContainerId, pPlayerInventory, this);
    }

    public int getComparatorOutput() {
        if (this.inventory == null) {
            return 0;
        }
        int itemsFound = 0;
        float proportion = 0.0f;
        int size = this.inventory.getContainerSize();
        for (int j = 0; j < size; ++j) {
            ItemStack itemstack = this.inventory.getItem(j);
            if (itemstack.isEmpty()) continue;
            proportion += (float)itemstack.getCount() / (float)itemstack.getMaxStackSize();
            ++itemsFound;
        }
        return Mth.floor((float)((proportion /= (float)size) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }

    public class PackagePortInventory
    implements SidedItemInventory {
        public static final int[] SLOTS = SlotRangeCache.get(18);
        public final NonNullList<ItemStack> stacks = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
        private boolean receive = true;

        public int[] getSlotsForFace(Direction side) {
            return SLOTS;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            String filterString = PackagePortBlockEntity.this.getFilterString();
            if (this.receive) {
                return filterString != null && PackageItem.matchAddress(stack, filterString);
            }
            return filterString == null || !PackageItem.matchAddress(stack, filterString);
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            String filterString = PackagePortBlockEntity.this.getFilterString();
            if (this.receive) {
                return filterString == null || !PackageItem.matchAddress(stack, filterString);
            }
            return filterString != null && PackageItem.matchAddress(stack, filterString);
        }

        public void receiveMode() {
            this.receive = true;
        }

        public void sendMode() {
            this.receive = false;
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return PackageItem.isPackage(stack);
        }

        public int getContainerSize() {
            return 18;
        }

        public ItemStack getItem(int slot) {
            if (slot >= 18) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)this.stacks.get(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= 18) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void setChanged() {
            PackagePortBlockEntity.this.notifyUpdate();
        }

        public void write(ValueOutput view) {
            ValueOutput.TypedOutputList list = view.list("Inventory", ItemStackWithSlot.CODEC);
            for (int i = 0; i < 18; ++i) {
                ItemStack stack = (ItemStack)this.stacks.get(i);
                if (stack.isEmpty()) continue;
                list.add((Object)new ItemStackWithSlot(i, stack));
            }
        }

        public void read(ValueInput view) {
            ValueInput.TypedInputList list = view.listOrEmpty("Inventory", ItemStackWithSlot.CODEC);
            for (int i = 0; i < 18; ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
            for (ItemStackWithSlot slot : list) {
                this.stacks.set(slot.slot(), (Object)slot.stack());
            }
        }
    }
}

