/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager;

import com.google.common.base.Predicate;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class PackagerBlockEntity
extends SmartBlockEntity {
    private static final Codec<List<BigItemStack>> EXITING_CODEC = BigItemStack.CODEC.listOf();
    public boolean redstonePowered;
    public int buttonCooldown;
    public String signBasedAddress;
    public InvManipulationBehaviour targetInventory;
    public ItemStack heldBox;
    public ItemStack previouslyUnwrapped;
    public List<BigItemStack> queuedExitingPackages;
    public final PackagerItemHandler inventory;
    public static final int CYCLE = 20;
    public int animationTicks;
    public boolean animationInward;
    public Boolean hasCustomComputerAddress;
    public String customComputerAddress;
    private InventorySummary availableItems;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public PackagerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.redstonePowered = (Boolean)state.getValueOrElse((Property)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        this.heldBox = ItemStack.EMPTY;
        this.previouslyUnwrapped = ItemStack.EMPTY;
        this.inventory = new PackagerItemHandler(this);
        this.animationTicks = 0;
        this.animationInward = true;
        this.queuedExitingPackages = new LinkedList<BigItemStack>();
        this.signBasedAddress = "";
        this.customComputerAddress = "";
        this.hasCustomComputerAddress = false;
        this.buttonCooldown = 0;
    }

    public PackagerBlockEntity(BlockPos pos, BlockState state) {
        this(AllBlockEntityTypes.PACKAGER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.targetInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing()).withFilter((Predicate<BlockEntity>)((Predicate)this::supportsBlockEntity));
        behaviours.add(this.targetInventory);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PACKAGER);
    }

    private boolean supportsBlockEntity(BlockEntity target) {
        return target != null && !(target instanceof PortableStorageInterfaceBlockEntity);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.recheckIfLinksPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonCooldown > 0) {
            --this.buttonCooldown;
        }
        if (this.animationTicks == 0) {
            this.previouslyUnwrapped = ItemStack.EMPTY;
            if (!this.level.isClientSide() && !this.queuedExitingPackages.isEmpty() && this.heldBox.isEmpty()) {
                BigItemStack entry = this.queuedExitingPackages.getFirst();
                this.heldBox = entry.stack.copy();
                --entry.count;
                if (entry.count <= 0) {
                    this.queuedExitingPackages.removeFirst();
                }
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
            }
            return;
        }
        if (this.level.isClientSide()) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.level.playLocalSound(this.worldPosition, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.level.isClientSide()) {
            this.wakeTheFrogs();
            this.setChanged();
        }
    }

    public void triggerStockCheck() {
        this.getAvailableItems();
    }

    public InventorySummary getAvailableItems() {
        if (this.availableItems != null && this.invVersionTracker.stillWaiting((Container)this.targetInventory.getInventory())) {
            return this.availableItems;
        }
        InventorySummary availableItems = new InventorySummary();
        Container targetInv = (Container)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            this.availableItems = availableItems;
            return availableItems;
        }
        if (targetInv instanceof BottomlessItemHandler) {
            BottomlessItemHandler bih = (BottomlessItemHandler)targetInv;
            availableItems.add(bih.getItem(0), 1000000000);
            this.availableItems = availableItems;
            return availableItems;
        }
        int size = targetInv.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            availableItems.add(targetInv.getItem(slot));
        }
        this.invVersionTracker.awaitNewVersion((Container)this.targetInventory.getInventory());
        this.submitNewArrivals(this.availableItems, availableItems);
        this.availableItems = availableItems;
        return availableItems;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        HashSet<RequestPromiseQueue> promiseQueues = new HashSet<RequestPromiseQueue>();
        for (Direction d : Iterate.directions) {
            Object object;
            if (!this.level.isLoaded(this.worldPosition.relative(d))) continue;
            BlockState adjacentState = this.level.getBlockState(this.worldPosition.relative(d));
            if (adjacentState.is((Block)AllBlocks.FACTORY_GAUGE)) {
                if (FactoryPanelBlock.connectedDirection(adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    ServerFactoryPanelBehaviour behaviour = (ServerFactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add(behaviour.restockerPromises);
                }
            }
            if (!adjacentState.is((Block)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d || !((object = this.level.getBlockEntity(this.worldPosition.relative(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add(Create.LOGISTICS.getQueuedPromises(freqId));
        }
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (BigItemStack entry : after.getStacks()) {
            before.add(entry.stack, -entry.count);
        }
        for (RequestPromiseQueue queue : promiseQueues) {
            for (BigItemStack entry : before.getStacks()) {
                if (entry.count >= 0) continue;
                queue.itemEnteredSystem(entry.stack, -entry.count);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        this.recheckIfLinksPresent();
        if (!this.redstonePowered) {
            return;
        }
        this.redstonePowered = (Boolean)this.getBlockState().getValueOrElse((Property)PackagerBlock.POWERED, (Comparable)Boolean.valueOf(false));
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
    }

    public void recheckIfLinksPresent() {
        boolean isLinked;
        if (this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!blockState.hasProperty((Property)PackagerBlock.LINKED)) {
            return;
        }
        boolean shouldBeLinked = this.getLinkPos() != null;
        if (shouldBeLinked == (isLinked = ((Boolean)blockState.getValue((Property)PackagerBlock.LINKED)).booleanValue())) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.cycle((Property)PackagerBlock.LINKED));
    }

    public boolean redstoneModeActive() {
        return (Boolean)this.getBlockState().getValueOrElse((Property)PackagerBlock.LINKED, (Comparable)Boolean.valueOf(false)) == false;
    }

    private BlockPos getLinkPos() {
        for (Direction d : Iterate.directions) {
            BlockState adjacentState = this.level.getBlockState(this.worldPosition.relative(d));
            if (!adjacentState.is((Block)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            return this.worldPosition.relative(d);
        }
        return null;
    }

    public void flashLink() {
        Direction[] directionArray = this.level;
        if (!(directionArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)directionArray;
        for (Direction d : Iterate.directions) {
            BlockPos adjacentPos = this.worldPosition.relative(d);
            BlockState adjacentState = this.level.getBlockState(adjacentPos);
            if (!adjacentState.is((Block)AllBlocks.STOCK_LINK) || PackagerLinkBlock.getConnectedDirection(adjacentState) != d) continue;
            serverWorld.getServer().getPlayerList().broadcast(null, (double)adjacentPos.getX(), (double)adjacentPos.getY(), (double)adjacentPos.getZ(), 32.0, serverWorld.dimension(), (Packet)new WiFiEffectPacket(adjacentPos));
            return;
        }
    }

    public boolean isTooBusyFor(LogisticallyLinkedBehaviour.RequestType type) {
        int queue = this.queuedExitingPackages.size();
        return queue >= (switch (type) {
            default -> throw new MatchException(null, null);
            case LogisticallyLinkedBehaviour.RequestType.PLAYER -> 50;
            case LogisticallyLinkedBehaviour.RequestType.REDSTONE -> 20;
            case LogisticallyLinkedBehaviour.RequestType.RESTOCK -> 10;
        });
    }

    public void activate() {
        this.redstonePowered = true;
        this.setChanged();
        this.recheckIfLinksPresent();
        if (!this.redstoneModeActive()) {
            return;
        }
        this.updateSignAddress();
        this.attemptToSend(null);
        if (this.buttonCooldown <= 0) {
            this.buttonCooldown = 40;
        }
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.level);
        ItemStackHandler contents = PackageItem.getContents(box);
        List<ItemStack> items = ItemHelper.getNonEmptyStacks(contents);
        if (items.isEmpty()) {
            return true;
        }
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext(box);
        Direction facing = (Direction)this.getBlockState().getValueOrElse((Property)PackagerBlock.FACING, (Comparable)Direction.UP);
        BlockPos target = this.worldPosition.relative(facing.getOpposite());
        BlockState targetState = this.level.getBlockState(target);
        UnpackingHandler handler = UnpackingHandler.REGISTRY.get((StateHolder<Block, ?>)targetState);
        UnpackingHandler toUse = handler != null ? handler : AllUnpackingHandlers.DEFAULT;
        boolean unpacked = toUse.unpack(this.level, target, targetState, facing, items, orderContext, simulate);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    public void attemptToSend(@Nullable List<PackagingRequest> queuedRequests) {
        BlockEntity blockEntity;
        boolean requestQueue;
        if (!(queuedRequests != null || this.heldBox.isEmpty() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        Container targetInv = (Container)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        MutableBoolean anyItemPresent = new MutableBoolean();
        ItemStackHandler extractedItems = new ItemStackHandler(9);
        ItemStack extractedPackageItem = ItemStack.EMPTY;
        PackagingRequest nextRequest = null;
        String fixedAddress = null;
        int fixedOrderId = 0;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        PackageOrderWithCrafts orderContext = null;
        boolean bl = requestQueue = queuedRequests != null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            nextRequest = queuedRequests.get(0);
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block0: for (int i = 0; i < 9; ++i) {
            boolean continuePacking = true;
            while (continuePacking) {
                Item item;
                continuePacking = false;
                if (requestQueue) {
                    int count;
                    int extract;
                    boolean bulky;
                    ItemStack stack2 = nextRequest.item();
                    item = stack2.getItem();
                    boolean bl2 = bulky = !item.canFitInsideContainerItems();
                    if (bulky && anyItemPresent.isTrue() || (extract = targetInv.extract(stack2, count = Math.min(64, nextRequest.getCount()))) == 0) break block0;
                    anyItemPresent.setTrue();
                    extractedItems.insert(stack2, extract);
                    if (item instanceof PackageItem) {
                        extractedPackageItem = stack2.copyWithCount(extract);
                    }
                    nextRequest.subtract(extract);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue block0;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    queuedRequests.removeFirst();
                    if (queuedRequests.isEmpty()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = queuedRequests.getFirst();
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue;
                    break block0;
                }
                ItemStack extracted = targetInv.extract(stack -> anyItemPresent.isFalse() || stack.getItem().canFitInsideContainerItems(), 64);
                if (extracted.isEmpty()) break block0;
                anyItemPresent.setTrue();
                extractedItems.insert(extracted);
                item = extracted.getItem();
                if (item instanceof PackageItem) {
                    extractedPackageItem = extracted;
                }
                if (item.canFitInsideContainerItems()) continue;
                break block0;
            }
        }
        if (anyItemPresent.isFalse()) {
            if (nextRequest != null) {
                queuedRequests.removeFirst();
            }
            return;
        }
        ItemStack createdBox = extractedPackageItem.isEmpty() ? PackageItem.containing(extractedItems) : extractedPackageItem;
        PackageItem.clearAddress(createdBox);
        if (fixedAddress != null && !fixedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, fixedAddress);
        }
        if (requestQueue) {
            PackageItem.setOrder(createdBox, fixedOrderId, linkIndexInOrder, finalLinkInOrder, packageIndexAtLink, finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(createdBox, this.signBasedAddress);
        }
        BlockPos linkPos = this.getLinkPos();
        if (extractedPackageItem.isEmpty() && linkPos != null && (blockEntity = this.level.getBlockEntity(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)blockEntity;
            plbe.behaviour.deductFromAccurateSummary(extractedItems);
        }
        if (!this.heldBox.isEmpty() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack(createdBox, 1));
            return;
        }
        this.heldBox = createdBox;
        this.animationInward = false;
        this.animationTicks = 20;
        this.award(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    public void updateSignAddress() {
        this.signBasedAddress = "";
        for (Direction side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.signBasedAddress = address;
        }
        this.hasCustomComputerAddress = false;
    }

    protected String getSign(Direction side) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity sign = (SignBlockEntity)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            SignText text = sign.getText(front);
            Object address = "";
            for (Component component : text.getMessages(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }

    protected void wakeTheFrogs() {
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.redstonePowered = view.getBooleanOr("Active", false);
        this.animationInward = view.getBooleanOr("AnimationInward", false);
        this.animationTicks = view.getIntOr("AnimationTicks", 0);
        this.signBasedAddress = view.getStringOr("SignAddress", "");
        this.customComputerAddress = view.getStringOr("ComputerAddress", "");
        this.hasCustomComputerAddress = view.getBooleanOr("HasComputerAddress", false);
        this.heldBox = view.read("HeldBox", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.previouslyUnwrapped = view.read("InsertedBox", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        if (clientPacket) {
            return;
        }
        this.queuedExitingPackages.clear();
        view.read("QueuedExitingPackages", EXITING_CODEC).ifPresent(list -> this.queuedExitingPackages.addAll((Collection<BigItemStack>)list));
        view.read("LastSummary", InventorySummary.CODEC).ifPresent(summary -> {
            this.availableItems = summary;
        });
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putBoolean("Active", this.redstonePowered);
        view.putBoolean("AnimationInward", this.animationInward);
        view.putInt("AnimationTicks", this.animationTicks);
        view.putString("SignAddress", this.signBasedAddress);
        view.putString("ComputerAddress", this.customComputerAddress);
        view.putBoolean("HasComputerAddress", this.hasCustomComputerAddress.booleanValue());
        if (!this.heldBox.isEmpty()) {
            view.store("HeldBox", ItemStack.CODEC, (Object)this.heldBox);
        }
        if (!this.previouslyUnwrapped.isEmpty()) {
            view.store("InsertedBox", ItemStack.CODEC, (Object)this.previouslyUnwrapped);
        }
        if (clientPacket) {
            return;
        }
        view.store("QueuedExitingPackages", EXITING_CODEC, this.queuedExitingPackages);
        if (this.availableItems != null) {
            view.store("LastSummary", InventorySummary.CODEC, (Object)this.availableItems);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.inventory);
        this.queuedExitingPackages.forEach(bigStack -> {
            for (int i = 0; i < bigStack.count; ++i) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)bigStack.stack.copy());
            }
        });
        this.queuedExitingPackages.clear();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = Mth.clamp((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public ItemStack getRenderedBox() {
        if (this.animationInward) {
            return this.animationTicks <= 10 ? ItemStack.EMPTY : this.previouslyUnwrapped;
        }
        return this.animationTicks >= 10 ? ItemStack.EMPTY : this.heldBox;
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        if (inventory == null) {
            return false;
        }
        Container targetHandler = (Container)this.targetInventory.getInventory();
        if (targetHandler == null) {
            return false;
        }
        if (inventory.identifier() != null) {
            BlockFace face = this.targetInventory.getTarget().getOpposite();
            return inventory.identifier().contains(face);
        }
        return PackagerBlockEntity.isSameInventoryFallback(targetHandler, inventory.handler());
    }

    private static boolean isSameInventoryFallback(Container first, Container second) {
        if (first == second) {
            return true;
        }
        int secondSize = second.getContainerSize();
        for (int i = 0; i < secondSize; ++i) {
            ItemStack stackInSlot = second.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            int firstSize = first.getContainerSize();
            for (int j = 0; j < firstSize; ++j) {
                if (stackInSlot != first.getItem(j)) continue;
                return true;
            }
            break;
        }
        return false;
    }
}

