/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagerLink;

import com.google.common.cache.Cache;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class LogisticallyLinkedBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<LogisticallyLinkedBehaviour> TYPE = new BehaviourType();
    public static final AtomicInteger LINK_ID_GENERATOR = new AtomicInteger();
    public int linkId;
    public int redstonePower;
    public UUID freqId;
    private boolean addedGlobally = false;
    private boolean loadedGlobally = false;
    private boolean global;
    private static final Cache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>> LINKS = new TickBasedCache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>>(20, true);
    private static final Cache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>> CLIENT_LINKS = new TickBasedCache<UUID, Cache<Integer, WeakReference<LogisticallyLinkedBehaviour>>>(20, true, true);

    public LogisticallyLinkedBehaviour(SmartBlockEntity be, boolean global) {
        super(be);
        this.global = global;
        this.linkId = LINK_ID_GENERATOR.getAndIncrement();
        this.freqId = UUID.randomUUID();
    }

    public static Collection<LogisticallyLinkedBehaviour> getAllPresent(UUID freq, boolean sortByPriority) {
        return LogisticallyLinkedBehaviour.getAllPresent(freq, sortByPriority, false);
    }

    public static Collection<LogisticallyLinkedBehaviour> getAllPresent(UUID freq, boolean sortByPriority, boolean clientSide) {
        Cache cache = (Cache)(clientSide ? CLIENT_LINKS : LINKS).getIfPresent((Object)freq);
        if (cache == null) {
            return Collections.emptyList();
        }
        Stream<LogisticallyLinkedBehaviour> stream = new LinkedList(cache.asMap().values()).stream().map(Reference::get).filter(LogisticallyLinkedBehaviour::isValidLink);
        if (sortByPriority) {
            stream = stream.sorted((e1, e2) -> Integer.compare(e1.redstonePower, e2.redstonePower));
        }
        return stream.toList();
    }

    public static void keepAlive(LogisticallyLinkedBehaviour behaviour) {
        boolean onClient = behaviour.blockEntity.getLevel().isClientSide();
        if (behaviour.redstonePower == 15) {
            return;
        }
        try {
            Cache cache = (Cache)(onClient ? CLIENT_LINKS : LINKS).get((Object)behaviour.freqId, () -> new TickBasedCache(400, false));
            if (cache == null) {
                return;
            }
            WeakReference<LogisticallyLinkedBehaviour> reference = (WeakReference<LogisticallyLinkedBehaviour>)cache.get((Object)behaviour.linkId, () -> new WeakReference<LogisticallyLinkedBehaviour>(behaviour));
            cache.put((Object)behaviour.linkId, (Object)(reference.get() != behaviour ? new WeakReference<LogisticallyLinkedBehaviour>(behaviour) : reference));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void remove(LogisticallyLinkedBehaviour behaviour) {
        Cache cache = (Cache)LINKS.getIfPresent((Object)behaviour.freqId);
        if (cache != null) {
            cache.invalidate((Object)behaviour.linkId);
        }
    }

    @Override
    public void unload() {
        if (this.loadedGlobally && this.global && this.getLevel() != null) {
            Create.LOGISTICS.linkInvalidated(this.freqId, this.getGlobalPos());
        }
        super.unload();
        LogisticallyLinkedBehaviour.remove(this);
    }

    @Override
    public void lazyTick() {
        LogisticallyLinkedBehaviour.keepAlive(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getLevel().isClientSide()) {
            return;
        }
        if (!this.loadedGlobally && this.global) {
            this.loadedGlobally = true;
            Create.LOGISTICS.linkLoaded(this.freqId, this.getGlobalPos());
        }
        if (!this.addedGlobally && this.global) {
            this.addedGlobally = true;
            this.blockEntity.setChanged();
            SmartBlockEntity smartBlockEntity = this.blockEntity;
            if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
                PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
                Create.LOGISTICS.linkAdded(this.freqId, this.getGlobalPos(), plbe.placedBy);
            }
        }
    }

    private GlobalPos getGlobalPos() {
        return GlobalPos.of((ResourceKey)this.getLevel().dimension(), (BlockPos)this.getPos());
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.addedGlobally && this.global && this.getLevel() != null) {
            Create.LOGISTICS.linkRemoved(this.freqId, this.getGlobalPos());
        }
    }

    public void redstonePowerChanged(int power) {
        if (power == this.redstonePower) {
            return;
        }
        this.redstonePower = power;
        this.blockEntity.setChanged();
        if (power == 15) {
            LogisticallyLinkedBehaviour.remove(this);
        } else {
            LogisticallyLinkedBehaviour.keepAlive(this);
        }
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(ItemStack stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, @Nullable PackageOrderWithCrafts context, @Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
            return plbe.processRequest(stack, amount, address, linkIndex, finalLink, orderId, context, ignoredHandler);
        }
        return null;
    }

    public InventorySummary getSummary(@Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)smartBlockEntity;
            return plbe.fetchSummaryFromPackager(ignoredHandler);
        }
        return InventorySummary.EMPTY;
    }

    public void deductFromAccurateSummary(ItemStackHandler packageContents) {
        InventorySummary summary = (InventorySummary)LogisticsManager.ACCURATE_SUMMARIES.getIfPresent((Object)this.freqId);
        if (summary == null) {
            return;
        }
        int size = packageContents.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack orderedStack = packageContents.getItem(i);
            if (orderedStack.isEmpty()) continue;
            summary.add(orderedStack, -Math.min(summary.getCountOf(orderedStack), orderedStack.getCount()));
        }
    }

    public boolean mayInteract(Player player) {
        return Create.LOGISTICS.mayInteract(this.freqId, player);
    }

    public boolean mayInteractMessage(Player player) {
        boolean mayInteract = Create.LOGISTICS.mayInteract(this.freqId, player);
        if (!mayInteract) {
            player.displayClientMessage((Component)Component.translatable((String)"create.logistically_linked.protected").withStyle(ChatFormatting.RED), true);
        }
        return mayInteract;
    }

    public boolean mayAdministrate(Player player) {
        return Create.LOGISTICS.mayAdministrate(this.freqId, player);
    }

    public static boolean isValidLink(LogisticallyLinkedBehaviour link) {
        return link != null && !link.blockEntity.isRemoved() && !link.blockEntity.isChunkUnloaded();
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void writeSafe(ValueOutput view) {
        view.store("Freq", UUIDUtil.CODEC, (Object)this.freqId);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.store("Freq", UUIDUtil.CODEC, (Object)this.freqId);
        view.putInt("Power", this.redstonePower);
        view.putBoolean("Added", this.addedGlobally);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.freqId = view.read("Freq", UUIDUtil.CODEC).orElse(null);
        this.redstonePower = view.getIntOr("Power", 0);
        this.addedGlobally = view.getBooleanOr("Added", false);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static enum RequestType {
        RESTOCK,
        REDSTONE,
        PLAYER;

    }
}

