/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlock;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StockTickerInteractionHandler {
    public static InteractionResult interactWithLogisticsManager(Entity entity, Player player, InteractionHand hand) {
        BlockPos targetPos = StockTickerInteractionHandler.getStockTickerPosition(entity);
        if (targetPos == null) {
            return null;
        }
        if (StockTickerInteractionHandler.interactWithLogisticsManagerAt(player, player.level(), targetPos)) {
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    public static boolean interactWithLogisticsManagerAt(Player player, Level level, BlockPos targetPos) {
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.is((Item)AllItems.SHOPPING_LIST)) {
            StockTickerInteractionHandler.interactWithShop(player, level, targetPos, mainHandItem);
            return true;
        }
        if (level.isClientSide()) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(targetPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return false;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
        if (!stbe.behaviour.mayInteract(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.locked").withStyle(ChatFormatting.RED), true);
            return true;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            MenuProvider.openHandledScreen(sp, stbe::createRequestMenu);
            stbe.getRecentSummary().divideAndSendTo(sp, targetPos);
        }
        return true;
    }

    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(targetPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)blockEntity;
        ShoppingList list = ShoppingListItem.getList(mainHandItem);
        if (list == null) {
            return;
        }
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.wrong_network").withStyle(ChatFormatting.RED), true);
            return;
        }
        Couple<InventorySummary> bakeEntries = list.bakeEntries((LevelAccessor)level, null);
        InventorySummary paymentEntries = (InventorySummary)bakeEntries.getSecond();
        InventorySummary orderEntries = (InventorySummary)bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());
        tickerBE.getAccurateSummary();
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (BigItemStack bigItemStack : order.stacks()) {
            if (recentSummary.getCountOf(bigItemStack.stack) >= bigItemStack.count) continue;
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.stock_level_too_low").withStyle(ChatFormatting.RED), true);
            return;
        }
        int occupiedSlots = 0;
        for (BigItemStack entry : paymentEntries.getStacksByCount()) {
            occupiedSlots += Mth.ceil((float)((float)entry.count / (float)entry.stack.getMaxStackSize()));
        }
        StockTickerBlockEntity.StockTickerInventory stockTickerInventory = tickerBE.receivedPayments;
        int size = stockTickerInventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (!stockTickerInventory.getItem(i).isEmpty()) continue;
            --occupiedSlots;
        }
        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.cash_register_full").withStyle(ChatFormatting.RED), true);
            return;
        }
        Inventory playerInventory = player.getInventory();
        for (boolean simulate : Iterate.trueAndFalse) {
            InventorySummary tally = paymentEntries.copy();
            ArrayList<ItemStack> toTransfer = new ArrayList<ItemStack>();
            for (int i = 0; i < 36; ++i) {
                int countOf;
                ItemStack item = playerInventory.getItem(i);
                if (item.isEmpty() || (countOf = tally.getCountOf(item)) == 0) continue;
                int toRemove = Math.min(item.getCount(), countOf);
                tally.add(item, -toRemove);
                if (simulate) continue;
                int newStackSize = item.getCount() - toRemove;
                playerInventory.setItem(i, newStackSize == 0 ? ItemStack.EMPTY : item.copyWithCount(newStackSize));
                toTransfer.add(item.copyWithCount(toRemove));
            }
            if (simulate && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.blockPosition());
                player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.too_broke").withStyle(ChatFormatting.RED), true);
                return;
            }
            if (simulate) continue;
            stockTickerInventory.insert(toTransfer);
        }
        tickerBE.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, ShoppingListItem.getAddress(mainHandItem));
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        if (!order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, (Vec3i)tickerBE.getBlockPos());
        }
    }

    public static BlockPos getStockTickerPosition(Entity entity) {
        Entity rootVehicle = entity.getRootVehicle();
        if (!(rootVehicle instanceof SeatEntity)) {
            return null;
        }
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        if (entity.getType() == AllEntityTypes.PACKAGE) {
            return null;
        }
        BlockPos pos = entity.blockPosition();
        int stations = 0;
        BlockPos targetPos = null;
        Level world = entity.level();
        for (Direction d : Iterate.horizontalDirections) {
            for (int y : Iterate.zeroAndOne) {
                BlockPos workstationPos = pos.relative(d).above(y);
                if (!(world.getBlockState(workstationPos).getBlock() instanceof StockTickerBlock)) continue;
                targetPos = workstationPos;
                ++stations;
            }
        }
        if (stations != 1) {
            return null;
        }
        return targetPos;
    }
}

