/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.TunnelFlapPacket;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BeltTunnelBlockEntity
extends SmartBlockEntity {
    public Map<Direction, LerpedFloat> flaps = new EnumMap<Direction, LerpedFloat>(Direction.class);
    public Set<Direction> sides = new HashSet<Direction>();
    public Container cap = null;
    protected List<Pair<Direction, Boolean>> flapsToSend = new LinkedList<Pair<Direction, Boolean>>();

    public BeltTunnelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static BeltTunnelBlockEntity andesite(BlockPos pos, BlockState state) {
        return new BeltTunnelBlockEntity(AllBlockEntityTypes.ANDESITE_TUNNEL, pos, state);
    }

    protected void writeFlapsAndSides(ValueOutput view) {
        ValueOutput.TypedOutputList flapsList = view.list("Flaps", (Codec)Direction.CODEC);
        for (Direction direction : this.flaps.keySet()) {
            flapsList.add((Object)direction);
        }
        ValueOutput.TypedOutputList sidesList = view.list("Sides", (Codec)Direction.CODEC);
        for (Direction direction : this.sides) {
            sidesList.add((Object)direction);
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        this.writeFlapsAndSides(view);
        super.writeSafe(view);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        this.writeFlapsAndSides(view);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        HashSet<Direction> newFlaps = new HashSet<Direction>(6);
        ValueInput.TypedInputList flapsList = view.listOrEmpty("Flaps", (Codec)Direction.CODEC);
        for (Direction direction : flapsList) {
            newFlaps.add(direction);
        }
        this.sides.clear();
        ValueInput.TypedInputList sidesList = view.listOrEmpty("Sides", (Codec)Direction.CODEC);
        for (Direction direction : sidesList) {
            this.sides.add(direction);
        }
        for (Direction d : Iterate.directions) {
            if (!newFlaps.contains(d)) {
                this.flaps.remove(d);
                continue;
            }
            if (this.flaps.containsKey(d)) continue;
            this.flaps.put(d, this.createChasingFlap());
        }
        super.read(view, clientPacket);
        if (clientPacket) {
            AllClientHandle.INSTANCE.queueUpdate(this);
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, 0.05f, LerpedFloat.Chaser.EXP);
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        this.sides.clear();
        BlockState tunnelState = this.getBlockState();
        for (Direction direction : Iterate.horizontalDirections) {
            BlockState nextState;
            if (direction.getAxis() != tunnelState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                boolean positive = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ^ direction.getAxis() == Direction.Axis.Z;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.getValue(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.sides.add(direction);
            if (this.level == null || (nextState = this.level.getBlockState(this.worldPosition.relative(direction))).getBlock() instanceof BeltTunnelBlock || nextState.getBlock() instanceof BeltFunnelBlock && nextState.getValue(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.getValue((Property)BeltFunnelBlock.HORIZONTAL_FACING) == direction.getOpposite()) continue;
            this.flaps.put(direction, this.createChasingFlap());
        }
        this.sendData();
    }

    public void flap(Direction side, boolean inward) {
        if (this.level.isClientSide()) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).setValue(inward ? -1.0 : 1.0);
            }
            return;
        }
        this.flapsToSend.add((Pair<Direction, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateTunnelConnections();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendFlaps();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tickChaser());
    }

    private void sendFlaps() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TunnelFlapPacket packet = new TunnelFlapPacket(this, this.flapsToSend);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false)) {
                player.connection.send((Packet)packet);
            }
        }
        this.flapsToSend.clear();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }
}

