/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemVaultBlock
extends Block
implements IWrenchable,
IBE<ItemVaultBlockEntity>,
ItemInventoryProvider<ItemVaultBlockEntity> {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty LARGE = BooleanProperty.create((String)"large");

    public ItemVaultBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, ItemVaultBlockEntity blockEntity, Direction context) {
        Container inventory;
        if (blockEntity.itemCapability != null && (inventory = (Container)blockEntity.itemCapability.get()) != null) {
            return inventory;
        }
        blockEntity.initCapability();
        return blockEntity.itemCapability != null ? (Container)blockEntity.itemCapability.get() : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HORIZONTAL_AXIS, LARGE});
        super.createBlockStateDefinition(pBuilder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown() || (preferredAxis = ItemVaultBlock.getVaultBlockAxis(placedOn = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite())))) == null)) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)pContext.getHorizontalDirection().getAxis());
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.getBlock() == pState.getBlock()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ItemVaultBlockEntity::updateConnectivity);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace().getAxis().isVertical()) {
            BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
            if (be instanceof ItemVaultBlockEntity) {
                ItemVaultBlockEntity vault = (ItemVaultBlockEntity)be;
                ConnectivityHandler.splitMulti(vault);
                vault.removeController(true);
            }
            state = (BlockState)state.setValue((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel world, BlockPos pos, boolean pIsMoving) {
        if (state.hasBlockEntity()) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof ItemVaultBlockEntity)) {
                return;
            }
            ItemVaultBlockEntity vaultBE = (ItemVaultBlockEntity)be;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)vaultBE.inventory);
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti(vaultBE);
        }
    }

    public static boolean isVault(BlockState state) {
        return state.is((Block)AllBlocks.ITEM_VAULT);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ItemVaultBlock.isVault(state)) {
            return null;
        }
        return (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state) {
        if (!ItemVaultBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)LARGE);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)rot.rotate(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).getAxis());
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public boolean hasAnalogOutputSignal(BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos, Direction direction) {
        return ItemHelper.calcRedstoneFromBlockEntity(this, pLevel, pPos);
    }

    @Override
    public BlockEntityType<? extends ItemVaultBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ITEM_VAULT;
    }

    @Override
    public Class<ItemVaultBlockEntity> getBlockEntityClass() {
        return ItemVaultBlockEntity.class;
    }
}

