/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlock;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.ItemPlacementSoundContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemVaultItem
extends BlockItem {
    public ItemVaultItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
        super(p_i48527_1_, p_i48527_2_);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockPos, Level level, Player player, ItemStack itemStack, BlockState blockState) {
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        TypedEntityData data = (TypedEntityData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null) {
            CompoundTag nbt = data.copyTagWithoutId();
            nbt.remove("Length");
            nbt.remove("Size");
            nbt.remove("Controller");
            nbt.remove("LastKnownPos");
            itemStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)TypedEntityData.of(((IBE)this.getBlock()).getBlockEntityType(), (CompoundTag)nbt));
        }
        return super.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockState placedOnState = world.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!ItemVaultBlock.isVault(placedOnState)) {
            return;
        }
        if (SymmetryWandItem.presentInHotbar(player)) {
            return;
        }
        ItemVaultBlockEntity tankAt = (ItemVaultBlockEntity)ConnectivityHandler.partAt(AllBlockEntityTypes.ITEM_VAULT, (BlockGetter)world, placedOnPos);
        if (tankAt == null) {
            return;
        }
        ItemVaultBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.radius;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis vaultBlockAxis = ItemVaultBlock.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null) {
            return;
        }
        if (face.getAxis() != vaultBlockAxis) {
            return;
        }
        Direction vaultFacing = Direction.fromAxisAndDirection((Direction.Axis)vaultBlockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == vaultFacing.getOpposite() ? controllerBE.getBlockPos().relative(vaultFacing.getOpposite()) : controllerBE.getBlockPos().relative(vaultFacing, controllerBE.length);
        if (VecHelper.getCoordinate((Vec3i)startPos, vaultBlockAxis) != VecHelper.getCoordinate((Vec3i)pos, vaultBlockAxis)) {
            return;
        }
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                BlockPos offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                BlockState blockState = world.getBlockState(offsetPos);
                if (ItemVaultBlock.isVault(blockState)) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < tanksToPlace) {
            return;
        }
        ItemPlacementSoundContext context = new ItemPlacementSoundContext(ctx, 0.1f, 1.5f, null);
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                BlockPos offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : startPos.offset(xOffset, zOffset, 0);
                BlockState blockState = world.getBlockState(offsetPos);
                if (ItemVaultBlock.isVault(blockState)) continue;
                super.place((BlockPlaceContext)context.offset(offsetPos, face));
            }
        }
    }
}

