/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.recipe;

import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class ProcessingInventory
implements SidedItemInventory {
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] ALL_SLOTS = SlotRangeCache.get(32);
    private static final Optional<Integer> LIMIT = Optional.of(1);
    public float remainingTime;
    public float recipeDuration;
    public boolean appliedRecipe;
    private boolean limit;
    private byte outputFlag = 0;
    private final Predicate<Direction> canInsert;
    private final Consumer<ItemStack> callback;
    private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)32, (Object)ItemStack.EMPTY);

    public ProcessingInventory(Consumer<ItemStack> callback, Predicate<Direction> canInsert) {
        this.canInsert = canInsert;
        this.callback = callback;
    }

    public void outputAllowInsertion() {
        this.outputFlag = (byte)(this.limit ? 1 : 2);
        this.limit = false;
    }

    public void outputForbidInsertion() {
        this.limit = this.outputFlag == 1;
        this.outputFlag = 0;
    }

    public int getContainerSize() {
        return 32;
    }

    public int[] getSlotsForFace(Direction side) {
        return this.outputFlag == 0 ? INPUT_SLOTS : ALL_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        if (this.outputFlag == 0) {
            return slot == 0 && this.canInsert.test(dir);
        }
        return slot != 0;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.outputFlag == 0) {
            return this.isEmpty();
        }
        return true;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public ItemStack onExtract(ItemStack stack) {
        if (this.limit) {
            return this.removeMaxSize(stack, LIMIT);
        }
        return stack;
    }

    public ItemStack getItem(int slot) {
        if (slot >= 32) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 32) {
            return;
        }
        if (this.limit && stack != ItemStack.EMPTY) {
            this.setMaxSize(stack, LIMIT);
        }
        this.stacks.set(slot, (Object)stack);
        if (slot == 0 && !stack.isEmpty()) {
            this.callback.accept(stack);
        }
    }

    public ProcessingInventory withSlotLimit(boolean limit) {
        this.limit = limit;
        return this;
    }

    public int getMaxStackSize() {
        return this.limit ? 1 : SidedItemInventory.super.getMaxStackSize();
    }

    @Override
    public void clearContent() {
        this.remainingTime = 0.0f;
        this.recipeDuration = 0.0f;
        this.appliedRecipe = false;
        SidedItemInventory.super.clearContent();
    }

    public void write(ValueOutput view) {
        ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.OPTIONAL_CODEC);
        list.add((Object)((ItemStack)this.stacks.getFirst()));
        for (int i = 1; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            list.add((Object)stack);
        }
        view.putFloat("ProcessingTime", this.remainingTime);
        view.putFloat("RecipeTime", this.recipeDuration);
        view.putBoolean("AppliedRecipe", this.appliedRecipe);
    }

    public void read(ValueInput view) {
        ValueInput.TypedInputList list = view.listOrEmpty("Inventory", ItemStack.OPTIONAL_CODEC);
        int i = 0;
        for (ItemStack itemStack : list) {
            this.stacks.set(i++, (Object)itemStack);
        }
        int size = this.stacks.size();
        while (i < size) {
            this.stacks.set(i, (Object)ItemStack.EMPTY);
            ++i;
        }
        this.remainingTime = view.getFloatOr("ProcessingTime", 0.0f);
        this.recipeDuration = view.getFloatOr("RecipeTime", 0.0f);
        this.appliedRecipe = view.getBooleanOr("AppliedRecipe", false);
        if (this.appliedRecipe && this.isEmpty()) {
            this.appliedRecipe = false;
        }
    }
}

