/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.analogLever;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class AnalogLeverBlockEntity
extends SmartBlockEntity {
    int state = 0;
    int lastChange;
    public LerpedFloat clientState = LerpedFloat.linear();

    public AnalogLeverBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.ANALOG_LEVER, pos, state);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("State", this.state);
        view.putInt("ChangeTimer", this.lastChange);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.state = view.getIntOr("State", 0);
        this.lastChange = view.getIntOr("ChangeTimer", 0);
        this.clientState.chase(this.state, 0.2f, LerpedFloat.Chaser.EXP);
        super.read(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastChange > 0) {
            --this.lastChange;
            if (this.lastChange == 0) {
                this.updateOutput();
            }
        }
        if (this.level.isClientSide()) {
            this.clientState.tickChaser();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    private void updateOutput() {
        AnalogLeverBlock.updateNeighbors(this.getBlockState(), this.level, this.worldPosition);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void changeState(boolean back) {
        int prevState = this.state;
        this.state += back ? -1 : 1;
        this.state = Mth.clamp((int)this.state, (int)0, (int)15);
        if (prevState != this.state) {
            this.lastChange = 15;
        }
        this.sendData();
    }

    public int getState() {
        return this.state;
    }
}

