/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.AccumulatedItemCountDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemThroughputDisplaySource
extends AccumulatedItemCountDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
    static final int POOL_SIZE = 10;

    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        CompoundTag conf = context.sourceConfig();
        if (conf.contains("Inactive")) {
            return ZERO.copy();
        }
        double interval = 20.0 * Math.pow(60.0, conf.getIntOr("Interval", 0));
        double rate = (double)conf.getFloatOr("Rate", 0.0f) * interval;
        if (rate > 0.0) {
            int lastAmount;
            double timeBetweenStacks;
            long previousTime = conf.getLongOr("LastReceived", 0L);
            long gameTime = context.blockEntity().getLevel().getGameTime();
            int diff = (int)(gameTime - previousTime);
            if (diff > 0 && (double)diff > (timeBetweenStacks = (double)(lastAmount = conf.getIntOr("LastReceivedAmount", 0)) / rate) * 2.0) {
                conf.putBoolean("Inactive", true);
            }
        }
        if (Mth.equal((double)rate, (double)0.0)) {
            rate = 0.0;
        }
        return Component.literal((String)this.format.format(rate).replace("\u00a0", " "));
    }

    @Override
    public void itemReceived(DisplayLinkBlockEntity be, int amount) {
        if (((Boolean)be.getBlockState().getValueOrElse((Property)DisplayLinkBlock.POWERED, (Comparable)Boolean.valueOf(true))).booleanValue()) {
            return;
        }
        CompoundTag conf = be.getSourceConfig();
        long gameTime = be.getLevel().getGameTime();
        if (!conf.contains("LastReceived")) {
            conf.putLong("LastReceived", gameTime);
            return;
        }
        long previousTime = conf.getLongOr("LastReceived", 0L);
        ListTag rates = conf.getListOrEmpty("PrevRates");
        if (rates.size() != 10) {
            rates = new ListTag();
            for (int i = 0; i < 10; ++i) {
                rates.add((Object)FloatTag.valueOf((float)-1.0f));
            }
        }
        int poolIndex = conf.getIntOr("Index", 0) % 10;
        rates.set(poolIndex, (Tag)FloatTag.valueOf((float)((float)((double)amount / (double)(gameTime - previousTime)))));
        float rate = 0.0f;
        int validIntervals = 0;
        for (int i = 0; i < 10; ++i) {
            float pooledRate = rates.getFloatOr(i, 0.0f);
            if (!(pooledRate >= 0.0f)) continue;
            rate += pooledRate;
            ++validIntervals;
        }
        conf.remove("Rate");
        if (validIntervals > 0) {
            conf.putFloat("Rate", rate /= (float)validIntervals);
        }
        conf.remove("Inactive");
        conf.putInt("LastReceivedAmount", amount);
        conf.putLong("LastReceived", gameTime);
        conf.putInt("Index", poolIndex + 1);
        conf.put("PrevRates", (Tag)rates);
        be.updateGatheredData();
    }

    @Override
    protected String getTranslationKey() {
        return "item_throughput";
    }
}

