/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import com.zurrtum.create.content.trains.display.GlobalTrainDisplayData;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StationSummaryDisplaySource
extends DisplaySource {
    protected static final MutableComponent UNPREDICTABLE = Component.literal((String)" ~ ");
    protected static final List<MutableComponent> EMPTY_ENTRY_4 = ImmutableList.of((Object)WHITESPACE, (Object)Component.literal((String)" . "), (Object)WHITESPACE, (Object)WHITESPACE);
    protected static final List<MutableComponent> EMPTY_ENTRY_5 = ImmutableList.of((Object)WHITESPACE, (Object)Component.literal((String)" . "), (Object)WHITESPACE, (Object)WHITESPACE, (Object)WHITESPACE);

    @Override
    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        return EMPTY;
    }

    @Override
    public List<List<MutableComponent>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        String filter = context.sourceConfig().getStringOr("Filter", "");
        boolean hasPlatform = filter.contains("*");
        ArrayList<List<MutableComponent>> list = new ArrayList<List<MutableComponent>>();
        GlobalTrainDisplayData.prepare(filter, stats.maxRows()).forEach(prediction -> {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            if (prediction.ticks == -1 || prediction.ticks >= 11700) {
                lines.add(WHITESPACE);
                lines.add(UNPREDICTABLE);
            } else if (prediction.ticks < 200) {
                lines.add(WHITESPACE);
                lines.add(Component.translatable((String)"create.display_source.station_summary.now"));
            } else {
                int min = prediction.ticks / 1200;
                int sec = prediction.ticks / 20 % 60;
                if ((sec = Mth.ceil((float)((float)sec / 15.0f)) * 15) == 60) {
                    ++min;
                    sec = 0;
                }
                lines.add(min > 0 ? Component.literal((String)String.valueOf(min)) : WHITESPACE);
                lines.add(min > 0 ? Component.translatable((String)"create.display_source.station_summary.minutes") : Component.translatable((String)"create.display_source.station_summary.seconds", (Object[])new Object[]{sec}));
            }
            lines.add(prediction.train.name.copy());
            lines.add(prediction.scheduleTitle);
            if (!hasPlatform) {
                list.add(lines);
                return;
            }
            String platform = prediction.destination;
            for (String string : filter.split("\\*")) {
                if (string.isEmpty()) continue;
                platform = platform.replace(string, "");
            }
            platform = platform.replace("*", "?");
            lines.add(Component.literal((String)platform.trim()));
            list.add(lines);
        });
        if (!list.isEmpty()) {
            context.blockEntity().award(AllAdvancements.DISPLAY_BOARD);
        }
        int toPad = stats.maxRows() - list.size();
        for (int padding = 0; padding < toPad; ++padding) {
            list.add(hasPlatform ? EMPTY_ENTRY_5 : EMPTY_ENTRY_4);
        }
        return list;
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        CompoundTag conf = context.sourceConfig();
        int columnWidth = conf.getIntOr("NameColumn", 0);
        int columnWidth2 = conf.getIntOr("PlatformColumn", 0);
        boolean hasPlatform = conf.getStringOr("Filter", "").contains("*");
        String layoutName = "StationSummary" + columnWidth + hasPlatform + columnWidth2;
        if (layout.isLayout(layoutName)) {
            return;
        }
        ArrayList<FlapDisplaySection> list = new ArrayList<FlapDisplaySection>();
        int timeWidth = 20;
        float gapSize = 8.0f;
        float platformWidth = (float)columnWidth2 * 7.0f;
        FlapDisplaySection minutes = new FlapDisplaySection(7.0f, "numeric", false, false);
        FlapDisplaySection time = new FlapDisplaySection(timeWidth, "arrival_time", true, true);
        float totalSize = (float)flapDisplay.xSize * 32.0f - 4.0f - gapSize * 2.0f;
        totalSize = totalSize - (float)timeWidth - 7.0f;
        platformWidth = Math.min(platformWidth, totalSize - gapSize);
        platformWidth = (float)((int)(platformWidth / 7.0f)) * 7.0f;
        if (hasPlatform) {
            totalSize = totalSize - gapSize - platformWidth;
        }
        if (platformWidth == 0.0f && hasPlatform) {
            totalSize += gapSize;
        }
        int trainNameWidth = (int)((float)columnWidth / 100.0f * totalSize / 7.0f);
        int destinationWidth = Math.round((1.0f - (float)columnWidth / 100.0f) * totalSize / 7.0f);
        FlapDisplaySection trainName = new FlapDisplaySection((float)trainNameWidth * 7.0f, "alphabet", false, trainNameWidth > 0);
        FlapDisplaySection destination = new FlapDisplaySection((float)destinationWidth * 7.0f, "alphabet", false, hasPlatform && destinationWidth > 0 && platformWidth > 0.0f);
        FlapDisplaySection platform = new FlapDisplaySection(platformWidth, "numeric", false, false).rightAligned();
        list.add(minutes);
        list.add(time);
        list.add(trainName);
        list.add(destination);
        if (hasPlatform) {
            list.add(platform);
        }
        layout.configure(layoutName, list);
    }

    @Override
    protected String getTranslationKey() {
        return "station_summary";
    }

    @Override
    public void populateData(DisplayLinkContext context) {
        CompoundTag conf = context.sourceConfig();
        if (!conf.contains("PlatformColumn")) {
            conf.putInt("PlatformColumn", 3);
        }
        if (!conf.contains("NameColumn")) {
            conf.putInt("NameColumn", 50);
        }
        if (conf.contains("Filter")) {
            return;
        }
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
        GlobalStation station = stationBe.getStation();
        if (station == null) {
            return;
        }
        conf.putString("Filter", station.name);
    }
}

