/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.item.BeltConnectorItem;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class LaunchedItem {
    public int totalTicks;
    public int ticksRemaining;
    public BlockPos target;
    public ItemStack stack;

    private LaunchedItem(BlockPos start, BlockPos target, ItemStack stack) {
        this(target, stack, LaunchedItem.ticksForDistance(start, target), LaunchedItem.ticksForDistance(start, target));
    }

    private static int ticksForDistance(BlockPos start, BlockPos target) {
        return (int)Math.max(10.0, Math.sqrt(Math.sqrt(target.distSqr((Vec3i)start))) * 4.0);
    }

    LaunchedItem() {
    }

    private LaunchedItem(BlockPos target, ItemStack stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(Level world) {
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return false;
        }
        if (world.isClientSide()) {
            return false;
        }
        this.place(world);
        return true;
    }

    public void write(ValueOutput view) {
        view.putInt("TotalTicks", this.totalTicks);
        view.putInt("TicksLeft", this.ticksRemaining);
        if (!this.stack.isEmpty()) {
            view.store("Stack", ItemStack.CODEC, (Object)this.stack);
        }
        view.store("Target", BlockPos.CODEC, (Object)this.target);
    }

    public static LaunchedItem from(ValueInput view, HolderGetter<Block> holderGetter) {
        LaunchedItem item = ForBelt.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = ForBlockState.from(view, holderGetter);
        if (item != null) {
            return item;
        }
        item = new ForEntity();
        item.read(view, holderGetter);
        return item;
    }

    abstract void place(Level var1);

    void read(ValueInput view, HolderGetter<Block> holderGetter) {
        this.target = view.read("Target", BlockPos.CODEC).orElse(BlockPos.ZERO);
        this.ticksRemaining = view.getIntOr("TicksLeft", 0);
        this.totalTicks = view.getIntOr("TotalTicks", 0);
        this.stack = view.read("Stack", ItemStack.CODEC).orElse(ItemStack.EMPTY);
    }

    public static class ForBelt
    extends ForBlockState {
        public int length;
        public BeltBlockEntity.CasingType[] casings;

        public ForBelt() {
        }

        @Override
        public void write(ValueOutput view) {
            super.write(view);
            view.store("Length", (Codec)Codec.INT, (Object)this.length);
            view.putIntArray("Casing", Arrays.stream(this.casings).mapToInt(Enum::ordinal).toArray());
        }

        public static LaunchedItem from(ValueInput view, HolderGetter<Block> holderGetter) {
            return view.read("Length", (Codec)Codec.INT).map(length -> {
                ForBelt result = new ForBelt();
                result.read(view, holderGetter, (int)length);
                return result;
            }).orElse(null);
        }

        @Override
        void read(ValueInput view, HolderGetter<Block> holderGetter) {
            this.read(view, holderGetter, view.read("Length", (Codec)Codec.INT).orElse(0));
        }

        private void read(ValueInput view, HolderGetter<Block> holderGetter, int length) {
            this.length = length;
            int[] intArray = view.getIntArray("Casing").orElseGet(() -> new int[0]);
            this.casings = new BeltBlockEntity.CasingType[length];
            for (int i = 0; i < this.casings.length; ++i) {
                this.casings[i] = i >= intArray.length ? BeltBlockEntity.CasingType.NONE : BeltBlockEntity.CasingType.values()[Mth.clamp((int)intArray[i], (int)0, (int)(BeltBlockEntity.CasingType.values().length - 1))];
            }
            super.read(view, holderGetter);
        }

        public ForBelt(BlockPos start, BlockPos target, ItemStack stack, BlockState state, BeltBlockEntity.CasingType[] casings) {
            super(start, target, stack, state, null);
            this.casings = casings;
            this.length = casings.length;
        }

        @Override
        void place(Level world) {
            boolean isStart = this.state.getValue(BeltBlock.PART) == BeltPart.START;
            BlockPos offset = BeltBlock.nextSegmentPosition(this.state, BlockPos.ZERO, isStart);
            int i = this.length - 1;
            Direction.Axis axis = this.state.getValue(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS ? Direction.Axis.Y : ((Direction)this.state.getValue((Property)BeltBlock.HORIZONTAL_FACING)).getClockWise().getAxis();
            world.setBlockAndUpdate(this.target, (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)AbstractSimpleShaftBlock.AXIS, (Comparable)axis));
            BeltConnectorItem.createBelts(world, this.target, this.target.offset(offset.getX() * i, offset.getY() * i, offset.getZ() * i));
            for (int segment = 0; segment < this.length; ++segment) {
                BlockPos casingTarget;
                BlockEntity blockEntity;
                if (this.casings[segment] == BeltBlockEntity.CasingType.NONE || !((blockEntity = world.getBlockEntity(casingTarget = this.target.offset(offset.getX() * segment, offset.getY() * segment, offset.getZ() * segment))) instanceof BeltBlockEntity)) continue;
                BeltBlockEntity bbe = (BeltBlockEntity)blockEntity;
                bbe.setCasingType(this.casings[segment]);
            }
        }
    }

    public static class ForBlockState
    extends LaunchedItem {
        public BlockState state;
        public CompoundTag data;

        ForBlockState() {
        }

        public ForBlockState(BlockPos start, BlockPos target, ItemStack stack, BlockState state, CompoundTag data) {
            super(start, target, stack);
            this.state = state;
            this.data = data;
        }

        @Override
        public void write(ValueOutput view) {
            super.write(view);
            view.store("BlockState", BlockState.CODEC, (Object)this.state);
            if (this.data != null) {
                this.data.remove("x");
                this.data.remove("y");
                this.data.remove("z");
                this.data.remove("id");
                view.store("Data", CompoundTag.CODEC, (Object)this.data);
            }
        }

        public static LaunchedItem from(ValueInput view, HolderGetter<Block> holderGetter) {
            return view.read("BlockState", BlockState.CODEC).map(state -> {
                ForBlockState result = new ForBlockState();
                result.read(view, holderGetter, (BlockState)state);
                return result;
            }).orElse(null);
        }

        @Override
        void read(ValueInput view, HolderGetter<Block> holderGetter) {
            this.read(view, holderGetter, view.read("BlockState", BlockState.CODEC).orElseGet(() -> ((Block)Blocks.AIR).defaultBlockState()));
        }

        private void read(ValueInput view, HolderGetter<Block> holderGetter, BlockState state) {
            super.read(view, holderGetter);
            this.state = state;
            view.read("Data", CompoundTag.CODEC).ifPresent(nbt -> {
                this.data = nbt;
            });
        }

        @Override
        void place(Level world) {
            BlockHelper.placeSchematicBlock(world, this.state, this.target, this.stack, this.data);
        }
    }

    public static class ForEntity
    extends LaunchedItem {
        public Entity entity;
        private CompoundTag deferredTag;

        ForEntity() {
        }

        public ForEntity(BlockPos start, BlockPos target, ItemStack stack, Entity entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean update(Level world) {
            if (this.deferredTag == null) return super.update(world);
            if (this.entity != null) return super.update(world);
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "LaunchedItem.ForEntity", Create.LOGGER);){
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)this.deferredTag);
                Optional loadEntityUnchecked = EntityType.create((ValueInput)view, (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD);
                if (loadEntityUnchecked.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                this.entity = (Entity)loadEntityUnchecked.get();
            }
            catch (Exception var3) {
                return true;
            }
            this.deferredTag = null;
            return super.update(world);
        }

        @Override
        public void write(ValueOutput view) {
            super.write(view);
            if (this.entity != null) {
                ValueOutput data = view.child("Entity");
                EntityType entityType = this.entity.getType();
                Identifier id = EntityType.getKey((EntityType)entityType);
                if (id != null && entityType.canSerialize()) {
                    data.putString("id", id.toString());
                }
                this.entity.saveWithoutId(data);
            }
        }

        @Override
        void read(ValueInput view, HolderGetter<Block> holderGetter) {
            super.read(view, holderGetter);
            view.read("Entity", CompoundTag.CODEC).ifPresent(nbt -> {
                this.deferredTag = nbt;
            });
        }

        @Override
        void place(Level world) {
            if (this.entity != null) {
                world.addFreshEntity(this.entity);
            }
        }
    }
}

