/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.table;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SchematicTableBlockEntity
extends SmartBlockEntity
implements MenuProvider,
IInteractionChecker {
    public SchematicTableInventory inventory = new SchematicTableInventory();
    public boolean isUploading;
    public String uploadingSchematic = null;
    public float uploadingProgress = 0.0f;
    public boolean sendUpdate;

    public SchematicTableBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SCHEMATIC_TABLE, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inventory);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.inventory.read(view);
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (view.getBooleanOr("Uploading", false)) {
            this.isUploading = true;
            this.uploadingSchematic = view.getStringOr("Schematic", "");
            this.uploadingProgress = view.getFloatOr("Progress", 0.0f);
        } else {
            this.isUploading = false;
            this.uploadingSchematic = null;
            this.uploadingProgress = 0.0f;
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        this.inventory.write(view);
        super.write(view, clientPacket);
        if (clientPacket && this.isUploading) {
            view.putBoolean("Uploading", true);
            view.putString("Schematic", this.uploadingSchematic);
            view.putFloat("Progress", this.uploadingProgress);
        }
    }

    @Override
    public void tick() {
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
        }
    }

    public void startUpload(String schematic) {
        this.isUploading = true;
        this.uploadingProgress = 0.0f;
        this.uploadingSchematic = schematic;
        this.sendUpdate = true;
        this.inventory.setItem(0, ItemStack.EMPTY);
    }

    public void finishUpload() {
        this.isUploading = false;
        this.uploadingProgress = 0.0f;
        this.uploadingSchematic = null;
        this.sendUpdate = true;
    }

    public SchematicTableMenu createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
        this.sendToMenu(extraData);
        return new SchematicTableMenu(id, inv, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"create.gui.schematicTable.title");
    }

    @Override
    public boolean canPlayerUse(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public class SchematicTableInventory
    implements ItemInventory {
        ItemStack left = ItemStack.EMPTY;
        ItemStack right = ItemStack.EMPTY;

        public int getContainerSize() {
            return 2;
        }

        public ItemStack getItem(int slot) {
            if (slot >= 2) {
                return ItemStack.EMPTY;
            }
            return slot == 0 ? this.left : this.right;
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= 2) {
                return;
            }
            if (slot == 0) {
                this.left = stack;
            } else {
                this.right = stack;
            }
        }

        public void write(ValueOutput view) {
            ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.OPTIONAL_CODEC);
            list.add((Object)this.left);
            list.add((Object)this.right);
        }

        public void read(ValueInput view) {
            Iterator iterator = view.listOrEmpty("Inventory", ItemStack.OPTIONAL_CODEC).iterator();
            if (iterator.hasNext()) {
                this.left = (ItemStack)iterator.next();
                if (iterator.hasNext()) {
                    this.right = (ItemStack)iterator.next();
                }
            }
        }

        @Override
        public void setChanged() {
            SchematicTableBlockEntity.this.setChanged();
        }
    }
}

