/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class TrainMigration {
    Couple<TrackNodeLocation> locations;
    double positionOnOldEdge;
    boolean curve;
    Vec3 fallback;

    public TrainMigration() {
    }

    public TrainMigration(TravellingPoint point) {
        double t = point.position / point.edge.getLength();
        this.fallback = point.edge.getPosition(null, t);
        this.curve = point.edge.isTurn();
        this.positionOnOldEdge = point.position;
        this.locations = Couple.create(point.node1.getLocation(), point.node2.getLocation());
    }

    public TrackGraphLocation tryMigratingTo(TrackGraph graph) {
        TrackEdge edge;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getSecond()));
        if (node1 != null && node2 != null && (edge = graph.getConnectionsFrom(node1).get(node2)) != null) {
            TrackGraphLocation graphLocation = new TrackGraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = this.locations;
            graphLocation.position = this.positionOnOldEdge;
            return graphLocation;
        }
        if (this.curve) {
            return null;
        }
        Vec3 prevDirection = ((TrackNodeLocation)((Object)this.locations.getSecond())).getLocation().subtract(((TrackNodeLocation)((Object)this.locations.getFirst())).getLocation()).normalize();
        for (TrackNodeLocation loc : graph.getNodes()) {
            Vec3 nodeVec = loc.getLocation();
            if (nodeVec.distanceToSqr(this.fallback) > 1024.0) continue;
            TrackNode newNode1 = graph.locateNode(loc);
            for (Map.Entry<TrackNode, TrackEdge> entry : graph.getConnectionsFrom(newNode1).entrySet()) {
                Vec3 intersectSphere;
                TrackEdge edge2 = entry.getValue();
                if (edge2.isTurn()) continue;
                TrackNode newNode2 = entry.getKey();
                float radius = 0.015625f;
                Vec3 direction = edge2.getDirection(true);
                if (!Mth.equal((double)direction.dot(prevDirection), (double)1.0) || (intersectSphere = VecHelper.intersectSphere(nodeVec, direction, this.fallback, radius)) == null || !Mth.equal((double)direction.dot(intersectSphere.subtract(nodeVec).normalize()), (double)1.0)) continue;
                double edgeLength = edge2.getLength();
                double position = intersectSphere.distanceTo(nodeVec) - (double)radius;
                if (Double.isNaN(position) || position < 0.0 || position > edgeLength) continue;
                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = Couple.create(loc, newNode2.getLocation());
                graphLocation.position = position;
                return graphLocation;
            }
        }
        return null;
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        view.putBoolean("Curve", this.curve);
        view.store("Fallback", Vec3.CODEC, (Object)this.fallback);
        view.putDouble("Position", this.positionOnOldEdge);
        ValueOutput.ValueOutputList list = view.childrenList("Nodes");
        ((TrackNodeLocation)((Object)this.locations.getFirst())).write(list.addChild(), dimensions);
        ((TrackNodeLocation)((Object)this.locations.getSecond())).write(list.addChild(), dimensions);
    }

    public static <T> DataResult<T> encode(TrainMigration input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Curve", ops.createBoolean(input.curve));
        map.add("Fallback", (Object)input.fallback, (Encoder)Vec3.CODEC);
        map.add("Curve", ops.createDouble(input.positionOnOldEdge));
        ListBuilder list = ops.listBuilder();
        list.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.locations.getFirst()), ops, empty, dimensions));
        list.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.locations.getSecond()), ops, empty, dimensions));
        map.add("Nodes", list.build(empty));
        return map.build(empty);
    }

    public static TrainMigration read(ValueInput view, DimensionPalette dimensions) {
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = view.getBooleanOr("Curve", false);
        trainMigration.fallback = view.read("Fallback", Vec3.CODEC).orElse(Vec3.ZERO);
        trainMigration.positionOnOldEdge = view.getDoubleOr("Position", 0.0);
        Iterator iterator = view.childrenListOrEmpty("Nodes").iterator();
        trainMigration.locations = Couple.create(TrackNodeLocation.read((ValueInput)iterator.next(), dimensions), TrackNodeLocation.read((ValueInput)iterator.next(), dimensions));
        return trainMigration;
    }

    public static <T> TrainMigration decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = ops.getBooleanValue(map.get("Curve")).result().orElse(false);
        trainMigration.fallback = Vec3.CODEC.parse(ops, map.get("Fallback")).result().orElse(Vec3.ZERO);
        trainMigration.positionOnOldEdge = ops.getNumberValue(map.get("Position"), (Number)0).doubleValue();
        Iterator iterator = ((Stream)ops.getStream(map.get("Nodes")).getOrThrow()).iterator();
        trainMigration.locations = Couple.create(TrackNodeLocation.decode(ops, iterator.next(), dimensions), TrackNodeLocation.decode(ops, iterator.next(), dimensions));
        return trainMigration;
    }
}

