/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity;

import com.zurrtum.create.foundation.blockEntity.EntityControlStructureProcessor;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureEntityInfoIterator
implements Iterator<StructureTemplate.StructureEntityInfo> {
    private final Level world;
    private final List<EntityControlStructureProcessor> controls;
    private Iterator<StructureTemplate.StructureEntityInfo> iterator;
    private StructureTemplate.StructureEntityInfo next;

    public StructureEntityInfoIterator(Level world, List<EntityControlStructureProcessor> controls, Iterator<StructureTemplate.StructureEntityInfo> iterator) {
        this.world = world;
        this.controls = controls;
        this.iterator = iterator;
    }

    private boolean test(StructureTemplate.StructureEntityInfo info) {
        for (EntityControlStructureProcessor processor : this.controls) {
            if (!processor.skip(this.world, info)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.iterator == null) {
            return false;
        }
        while (this.iterator.hasNext()) {
            StructureTemplate.StructureEntityInfo info = this.iterator.next();
            if (!this.test(info)) continue;
            this.next = info;
            return true;
        }
        this.iterator = null;
        return false;
    }

    @Override
    public StructureTemplate.StructureEntityInfo next() {
        if (this.hasNext()) {
            StructureTemplate.StructureEntityInfo result = this.next;
            this.next = null;
            return result;
        }
        throw new NoSuchElementException();
    }
}

