/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour;

import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;

public interface ValueSettingsHandleBehaviour
extends ClipboardCloneable {
    default public boolean acceptsValueSettings() {
        return true;
    }

    default public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
    }

    default public boolean mayInteract(Player player) {
        return true;
    }

    default public int netId() {
        return 0;
    }

    public ValueSettings getValueSettings();

    default public void setValueSettings(Player player, ValueSettings valueSetting, boolean ctrlDown) {
    }

    default public void playFeedbackSound(BlockEntityBehaviour<?> origin) {
        origin.getLevel().playSound(null, origin.getPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 2.0f);
        origin.getLevel().playSound(null, origin.getPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value(), SoundSource.BLOCKS, 0.03f, 1.125f);
    }

    @Override
    default public String getClipboardKey() {
        return "Settings";
    }

    @Override
    default public boolean canWrite(HolderLookup.Provider registries, Direction side) {
        return this.acceptsValueSettings();
    }

    @Override
    default public boolean writeToClipboard(ValueOutput view, Direction side) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        ValueSettings valueSettings = this.getValueSettings();
        view.putInt("Value", valueSettings.value());
        view.putInt("Row", valueSettings.row());
        return true;
    }

    @Override
    default public boolean readFromClipboard(ValueInput view, Player player, Direction side, boolean simulate) {
        if (!this.acceptsValueSettings()) {
            return false;
        }
        Optional row = view.getInt("Row");
        if (row.isEmpty()) {
            return false;
        }
        Optional value = view.getInt("Value");
        if (value.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setValueSettings(player, new ValueSettings((Integer)row.get(), (Integer)value.get()), false);
        return true;
    }
}

