/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class AnimatedContainerBehaviour<M extends MenuBase<? extends SmartBlockEntity>>
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<AnimatedContainerBehaviour<?>> TYPE = new BehaviourType();
    public int openCount;
    private final Class<M> menuClass;
    private Consumer<Boolean> openChanged;

    public AnimatedContainerBehaviour(SmartBlockEntity be, Class<M> menuClass) {
        super(be);
        this.menuClass = menuClass;
        this.openCount = 0;
    }

    public void onOpenChanged(Consumer<Boolean> openChanged) {
        this.openChanged = openChanged;
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            this.openCount = view.getIntOr("OpenCount", 0);
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket) {
            view.putInt("OpenCount", this.openCount);
        }
    }

    @Override
    public void lazyTick() {
        this.updateOpenCount();
        super.lazyTick();
    }

    void updateOpenCount() {
        Level level = this.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (this.openCount == 0) {
            return;
        }
        int prevOpenCount = this.openCount;
        this.openCount = 0;
        for (Player playerentity : level.getEntitiesOfClass(Player.class, new AABB(this.getPos()).inflate(8.0))) {
            if (!this.menuClass.isInstance(playerentity.containerMenu) || ((MenuBase)((Object)this.menuClass.cast((Object)playerentity.containerMenu))).contentHolder != this.blockEntity) continue;
            ++this.openCount;
        }
        if (prevOpenCount != this.openCount) {
            if (this.openChanged != null && prevOpenCount == 0 && this.openCount > 0) {
                this.openChanged.accept(true);
            }
            if (this.openChanged != null && prevOpenCount > 0 && this.openCount == 0) {
                this.openChanged.accept(false);
            }
            this.blockEntity.sendData();
        }
    }

    public void startOpen(Player player) {
        if (player.isSpectator()) {
            return;
        }
        if (this.getLevel().isClientSide()) {
            return;
        }
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        if (this.openCount == 1 && this.openChanged != null) {
            this.openChanged.accept(true);
        }
        this.blockEntity.sendData();
    }

    public void stopOpen(Player player) {
        if (player.isSpectator()) {
            return;
        }
        if (this.getLevel().isClientSide()) {
            return;
        }
        --this.openCount;
        if (this.openCount == 0 && this.openChanged != null) {
            this.openChanged.accept(false);
        }
        this.blockEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

