/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class InvManipulationBehaviour
extends CapManipulationBehaviourBase<Container, InvManipulationBehaviour> {
    public static final BehaviourType<InvManipulationBehaviour> TYPE = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> EXTRACT = new BehaviourType();
    public static final BehaviourType<InvManipulationBehaviour> INSERT = new BehaviourType();
    private final BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, be, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, be, target);
    }

    public InvManipulationBehaviour(SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(TYPE, be, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartBlockEntity be, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(be, target);
        this.behaviourType = type;
    }

    @Nullable
    public IdentifiedInventory getIdentifiedInventory() {
        Container inventory = (Container)this.getInventory();
        if (inventory == null) {
            return null;
        }
        InventoryIdentifier identifier = InventoryIdentifier.get(this.getLevel(), this.getTarget().getOpposite());
        return new IdentifiedInventory(identifier, inventory);
    }

    @Override
    protected Container getCapability(Level world, BlockPos pos, BlockEntity blockEntity, @Nullable Direction side) {
        return ItemHelper.getInventory(world, pos, null, blockEntity, side);
    }

    public ItemStack extract() {
        return this.extract(this.getModeFromFilter(), this.getAmountFromFilter());
    }

    public ItemStack extract(ItemHelper.ExtractionCountMode mode, int amount) {
        return this.extract(mode, amount, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public ItemStack extract(ItemHelper.ExtractionCountMode mode, int amount, Predicate<ItemStack> filter) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        if (this.getLevel().isClientSide()) {
            return ItemStack.EMPTY;
        }
        Container inventory = (Container)this.targetCapability;
        if (inventory == null) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> test = this.getFilterTest(filter);
        if (shouldSimulate) {
            ItemStack extract = inventory.count(test, amount);
            int count = extract.getCount();
            if (mode == ItemHelper.ExtractionCountMode.EXACTLY && count != amount) {
                return ItemStack.EMPTY;
            }
            int maxCount = extract.getMaxStackSize();
            if (count > maxCount) {
                extract.setCount(maxCount);
            }
            return extract;
        }
        if (mode == ItemHelper.ExtractionCountMode.UPTO) {
            ItemStack extract = inventory.count(test, amount);
            if (extract.isEmpty()) {
                return extract;
            }
            int count = inventory.extract(extract, Math.min(extract.getCount(), extract.getMaxStackSize()));
            extract.setCount(count);
            return extract;
        }
        return inventory.preciseExtract(test, amount);
    }

    public ItemStack insert(ItemStack stack) {
        int count;
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        Container inventory = (Container)this.targetCapability;
        if (inventory == null) {
            return stack;
        }
        int insert = shouldSimulate ? inventory.countSpace(stack) : inventory.insertExist(stack);
        if (insert == (count = stack.getCount())) {
            return ItemStack.EMPTY;
        }
        if (insert == 0) {
            return stack;
        }
        return stack.copyWithCount(count - insert);
    }

    protected Predicate<ItemStack> getFilterTest(Predicate<ItemStack> customFilter) {
        Predicate<ItemStack> test = customFilter;
        ServerFilteringBehaviour filter = this.blockEntity.getBehaviour(ServerFilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

