/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;

public class ServerScrollValueBehaviour
extends BlockEntityBehaviour<SmartBlockEntity>
implements ValueSettingsHandleBehaviour {
    public static final BehaviourType<ServerScrollValueBehaviour> TYPE = new BehaviourType();
    protected int value = 0;
    protected Consumer<Integer> callback = i -> {};
    protected int min = 0;
    protected int max = 1;

    public ServerScrollValueBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void setValue(int value) {
        if ((value = Mth.clamp((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.callback.accept(value);
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("ScrollValue", this.value);
        super.write(view, clientPacket);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.value = view.getIntOr("ScrollValue", 0);
        super.read(view, clientPacket);
    }

    public ServerScrollValueBehaviour withCallback(Consumer<Integer> valueCallback) {
        this.callback = valueCallback;
        return this;
    }

    public ServerScrollValueBehaviour between(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        if (FakePlayerHandler.has((Entity)player)) {
            this.blockEntity.getBlockState().useItemOn(player.getItemInHand(hand), this.getLevel(), player, hand, hitResult);
        }
    }

    @Override
    public void setValueSettings(Player player, ValueSettings valueSetting, boolean ctrlDown) {
        if (valueSetting.equals(this.getValueSettings())) {
            return;
        }
        this.setValue(valueSetting.value());
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(0, this.value);
    }
}

