/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FluidInventoryCache
implements Supplier<FluidInventory> {
    public final ServerLevel world;
    public final Direction direction;
    public final BlockPos pos;
    public boolean cached;
    public FluidInventory inventory;
    public Supplier<FluidInventory> getter = this::refresh;

    public FluidInventoryCache(ServerLevel world, BlockPos pos, Direction direction) {
        this.world = world;
        this.direction = direction;
        this.pos = pos;
    }

    @Override
    public FluidInventory get() {
        if (this.cached) {
            return this.inventory;
        }
        this.inventory = this.getter.get();
        return this.inventory;
    }

    public void invalidate() {
        this.cached = false;
        this.getter = this::refresh;
    }

    private FluidInventory refresh() {
        this.cached = true;
        BlockState state = this.world.getBlockState(this.pos);
        Block block = state.getBlock();
        if (block instanceof FluidInventoryProvider) {
            FluidInventoryProvider provider = (FluidInventoryProvider)block;
            return provider.getFluidInventory(state, (LevelAccessor)this.world, this.pos, null, this.direction);
        }
        this.getter = AllTransfer.getCacheFluidInventory(this.world, this.pos, this.direction);
        if (this.getter == null) {
            return null;
        }
        this.cached = false;
        return this.getter.get();
    }
}

