/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record ShoppingList(@Unmodifiable List<IntAttached<BlockPos>> purchases, UUID shopOwner, UUID shopNetwork) {
    public static final Codec<ShoppingList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntAttached.codec(BlockPos.CODEC).listOf().fieldOf("purchases").forGetter(ShoppingList::purchases), (App)UUIDUtil.CODEC.fieldOf("shop_owner").forGetter(ShoppingList::shopOwner), (App)UUIDUtil.CODEC.fieldOf("shop_network").forGetter(ShoppingList::shopNetwork)).apply((Applicative)instance, ShoppingList::new));
    public static final StreamCodec<FriendlyByteBuf, ShoppingList> STREAM_CODEC = StreamCodec.composite(CatnipStreamCodecBuilders.list(IntAttached.streamCodec(BlockPos.STREAM_CODEC)), ShoppingList::purchases, (StreamCodec)UUIDUtil.STREAM_CODEC, ShoppingList::shopOwner, (StreamCodec)UUIDUtil.STREAM_CODEC, ShoppingList::shopNetwork, ShoppingList::new);

    public ShoppingList duplicate() {
        return new ShoppingList(new ArrayList<IntAttached<BlockPos>>(this.purchases.stream().map(ia -> IntAttached.with((Integer)ia.getFirst(), (BlockPos)ia.getSecond())).toList()), this.shopOwner, this.shopNetwork);
    }

    public int getPurchases(BlockPos clothPos) {
        for (IntAttached<BlockPos> entry : this.purchases) {
            if (!clothPos.equals((Object)entry.getValue())) continue;
            return (Integer)entry.getFirst();
        }
        return 0;
    }

    public Couple<InventorySummary> bakeEntries(LevelAccessor level, @Nullable BlockPos clothPosToIgnore) {
        InventorySummary input = new InventorySummary();
        InventorySummary output = new InventorySummary();
        for (IntAttached<BlockPos> entry : this.purchases) {
            Object object;
            if (clothPosToIgnore != null && clothPosToIgnore.equals((Object)entry.getValue()) || !((object = level.getBlockEntity(entry.getValue())) instanceof TableClothBlockEntity)) continue;
            TableClothBlockEntity dcbe = (TableClothBlockEntity)object;
            input.add(dcbe.getPaymentItem(), dcbe.getPaymentAmount() * (Integer)entry.getFirst());
            object = dcbe.requestData.encodedRequest().stacks().iterator();
            while (object.hasNext()) {
                BigItemStack stackEntry = (BigItemStack)object.next();
                output.add(stackEntry.stack, stackEntry.count * (Integer)entry.getFirst());
            }
        }
        return Couple.create(output, input);
    }

    public static class Mutable {
        private final List<IntAttached<BlockPos>> purchases = new ArrayList<IntAttached<BlockPos>>();
        private final UUID shopOwner;
        private final UUID shopNetwork;

        public Mutable(ShoppingList list) {
            this.purchases.addAll(list.purchases);
            this.shopOwner = list.shopOwner;
            this.shopNetwork = list.shopNetwork;
        }

        public void addPurchases(BlockPos clothPos, int amount) {
            for (IntAttached<BlockPos> entry : this.purchases) {
                if (!clothPos.equals((Object)entry.getValue())) continue;
                entry.setFirst((Integer)entry.getFirst() + amount);
                return;
            }
            this.purchases.add(IntAttached.with(amount, clothPos));
        }

        public ShoppingList toImmutable() {
            return new ShoppingList(this.purchases, this.shopOwner, this.shopNetwork);
        }
    }
}

