/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidStack
implements DataComponentHolder {
    public static final FluidStack EMPTY = new FluidStack(null);
    public static final Codec<Holder<Fluid>> FLUID_ENTRY_CODEC = BuiltInRegistries.FLUID.holderByNameCodec().validate(entry -> entry.is((Holder)Fluids.EMPTY.builtInRegistryHolder()) ? DataResult.error(() -> "Fluid must not be minecraft:empty") : DataResult.success((Object)entry));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Fluid>> FLUID_ENTRY_PACKET_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.FLUID);
    public static final MapCodec<FluidStack> MAP_CODEC = MapCodec.recursive((String)"FluidStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)FLUID_ENTRY_CODEC.fieldOf("id").forGetter(FluidStack::getRegistryEntry), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").orElse((Object)1).forGetter(FluidStack::getAmount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> stack.components.asPatch())).apply((Applicative)instance, FluidStack::new)));
    public static final Codec<FluidStack> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());
    public static final Codec<FluidStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStack> OPTIONAL_PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FluidStack>(){

        public FluidStack decode(RegistryFriendlyByteBuf registryByteBuf) {
            int i = registryByteBuf.readVarInt();
            if (i <= 0) {
                return EMPTY;
            }
            Holder registryEntry = (Holder)FLUID_ENTRY_PACKET_CODEC.decode((Object)registryByteBuf);
            DataComponentPatch componentChanges = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)registryByteBuf);
            return new FluidStack((Holder<Fluid>)registryEntry, i, componentChanges);
        }

        public void encode(RegistryFriendlyByteBuf registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                registryByteBuf.writeVarInt(0);
            } else {
                registryByteBuf.writeVarInt(fluidStack.getAmount());
                FLUID_ENTRY_PACKET_CODEC.encode((Object)registryByteBuf, fluidStack.getRegistryEntry());
                DataComponentPatch.STREAM_CODEC.encode((Object)registryByteBuf, (Object)fluidStack.components.asPatch());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStack> PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FluidStack>(){

        public FluidStack decode(RegistryFriendlyByteBuf registryByteBuf) {
            FluidStack fluidStack = (FluidStack)OPTIONAL_PACKET_CODEC.decode((Object)registryByteBuf);
            if (fluidStack.isEmpty()) {
                throw new DecoderException("Empty FluidStack not allowed");
            }
            return fluidStack;
        }

        public void encode(RegistryFriendlyByteBuf registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                throw new EncoderException("Empty FluidStack not allowed");
            }
            OPTIONAL_PACKET_CODEC.encode((Object)registryByteBuf, (Object)fluidStack);
        }
    };
    private final PatchedDataComponentMap components;
    private final Fluid fluid;
    private int amount;

    public FluidStack(Fluid fluid, int amount) {
        this(fluid, amount, new PatchedDataComponentMap(DataComponentMap.EMPTY));
    }

    public FluidStack(Fluid fluid, int amount, PatchedDataComponentMap components) {
        this.fluid = fluid;
        this.amount = amount;
        this.components = components;
    }

    private FluidStack(@Nullable Void v) {
        this.fluid = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public FluidStack(Holder<Fluid> fluid, int amount, DataComponentPatch changes) {
        this((Fluid)fluid.value(), amount, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)changes));
    }

    public FluidStack(Fluid fluid, int amount, DataComponentPatch changes) {
        this(fluid, amount, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)changes));
    }

    public FluidStack(Fluid fluid, long amount, DataComponentPatch changes) {
        this(fluid, (int)amount, PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)changes));
    }

    public static boolean areFluidsAndComponentsEqual(FluidStack stack, FluidStack otherStack) {
        if (!stack.isOf(otherStack.getFluid())) {
            return false;
        }
        return stack.isEmpty() && otherStack.isEmpty() || Objects.equals(stack.components, otherStack.components);
    }

    public static boolean areFluidsAndComponentsEqualIgnoreCapacity(FluidStack stack, FluidStack otherStack) {
        if (stack.isOf(otherStack.getFluid())) {
            PatchedDataComponentMap otherStackComponents;
            PatchedDataComponentMap stackComponents = stack.directComponents();
            if (stackComponents == (otherStackComponents = otherStack.directComponents())) {
                return true;
            }
            Reference2ObjectMap stackComponentMap = stackComponents.patch;
            Reference2ObjectMap otherStackComponentMap = otherStackComponents.patch;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                --stackComponentCount;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                --otherStackComponentCount;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (stackComponentSet.contains((Object)componentEntry) || componentEntry.getKey() == AllDataComponents.FLUID_MAX_CAPACITY) continue;
                    return false;
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll((Collection)otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    public static Optional<FluidStack> fromNbt(HolderLookup.Provider registries, Tag nbt) {
        return CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(error -> Create.LOGGER.error("Tried to load invalid fluid: '{}'", error));
    }

    public static FluidStack fromNbt(HolderLookup.Provider registries, Optional<CompoundTag> nbt) {
        return nbt.flatMap(n -> FluidStack.fromNbt(registries, (Tag)n)).orElse(EMPTY);
    }

    public static int hashCode(@Nullable FluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getFluid().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }

    public void applyComponentsFrom(DataComponentMap map) {
        this.components.setAll(map);
    }

    public void capAmount(int maxCount) {
        if (!this.isEmpty() && this.getAmount() > maxCount) {
            this.setAmount(maxCount);
        }
    }

    public FluidStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new FluidStack(this.fluid, this.amount, this.components.copy());
    }

    public FluidStack copyWithAmount(int amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new FluidStack(this.fluid, amount, this.components.copy());
    }

    public void decrement(int amount) {
        this.increment(-amount);
    }

    public PatchedDataComponentMap directComponents() {
        return this.components;
    }

    public FluidStack directCopy(int amount) {
        return new FluidStack(this.fluid, amount, this.components.copy());
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public DataComponentPatch getComponentChanges() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public Fluid getFluid() {
        return this.isEmpty() ? Fluids.EMPTY : this.fluid;
    }

    public int getMaxAmount() {
        return (Integer)this.getOrDefault(AllDataComponents.FLUID_MAX_CAPACITY, Integer.MAX_VALUE);
    }

    public Component getName() {
        if (this.fluid == AllFluids.POTION) {
            PotionContents contents = (PotionContents)this.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            Item itemFromBottleType = PotionFluidHandler.itemFromBottleType((BottleType)((Object)this.getOrDefault(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR)));
            return contents.getName(itemFromBottleType.asItem().getDescriptionId() + ".effect.");
        }
        Block block = this.fluid.defaultFluidState().createLegacyBlock().getBlock();
        if (this.fluid != Fluids.EMPTY && block == Blocks.AIR) {
            return Component.translatable((String)Util.makeDescriptionId((String)"block", (Identifier)BuiltInRegistries.FLUID.getKey((Object)this.fluid)));
        }
        return block.getName();
    }

    public Holder<Fluid> getRegistryEntry() {
        return this.getFluid().builtInRegistryHolder();
    }

    public void increment(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.fluid == Fluids.EMPTY || this.amount <= 0;
    }

    public boolean isIn(TagKey<Fluid> tag) {
        return this.getFluid().builtInRegistryHolder().is(tag);
    }

    public boolean isOf(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        return (T)this.components.remove(type);
    }

    @Nullable
    public <T> T set(DataComponentType<T> type, @Nullable T value) {
        return (T)this.components.set(type, value);
    }

    public FluidStack split(int amount) {
        int i = Math.min(amount, this.getAmount());
        FluidStack stack = this.copyWithAmount(i);
        this.decrement(i);
        return stack;
    }

    public Tag toNbt(HolderLookup.Provider registries) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty FluidStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public String toString() {
        return this.getAmount() + " " + BuiltInRegistries.FLUID.wrapAsHolder((Object)this.getFluid()).getRegisteredName();
    }
}

