/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.data;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1936;

public class WorldAttached<T> {
    static List<WeakReference<Map<class_1936, ?>>> allMaps = new ArrayList();
    private final Map<class_1936, T> attached;
    private final Function<class_1936, T> factory;

    public WorldAttached(Function<class_1936, T> factory) {
        this.factory = factory;
        this.attached = new WeakHashMap<class_1936, T>();
        allMaps.add(new WeakReference<Map<class_1936, T>>(this.attached));
    }

    public static void invalidateWorld(class_1936 world) {
        Iterator<WeakReference<Map<class_1936, ?>>> i = allMaps.iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next().get();
            if (map == null) {
                i.remove();
                continue;
            }
            map.remove(world);
        }
    }

    public T get(class_1936 world) {
        T t = this.attached.get(world);
        if (t != null) {
            return t;
        }
        T entry = this.factory.apply(world);
        this.put(world, entry);
        return entry;
    }

    public void put(class_1936 world, T entry) {
        this.attached.put(world, entry);
    }

    public T replace(class_1936 world) {
        this.attached.remove(world);
        return this.get(world);
    }

    public T replace(class_1936 world, Consumer<T> finalizer) {
        T remove = this.attached.remove(world);
        if (remove != null) {
            finalizer.accept(remove);
        }
        return this.get(world);
    }

    public void empty(BiConsumer<class_1936, T> finalizer) {
        this.attached.forEach(finalizer);
        this.attached.clear();
    }

    public void empty(Consumer<T> finalizer) {
        this.attached.values().forEach(finalizer);
        this.attached.clear();
    }
}

