/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.infrastructure.packet.c2s.ElevatorTargetFloorPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionDisableActorPacket;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2688;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContraptionControlsMovingInteraction
extends MovingInteractionBehaviour {
    @Override
    public boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        MutablePair<class_3499.class_3501, MovementContext> actor = contraption.getActorAt(localPos);
        if (actor == null) {
            return false;
        }
        MovementContext ctx = (MovementContext)actor.right;
        if (ctx == null) {
            return false;
        }
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            return this.elevatorInteraction(player, localPos, contraptionEntity, ec, ctx);
        }
        if (contraptionEntity.method_37908().method_8608()) {
            class_2586 class_25862 = AllClientHandle.INSTANCE.getBlockEntityClientSide(contraption, ctx.localPos);
            if (class_25862 instanceof ContraptionControlsBlockEntity) {
                ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)class_25862;
                cbe.pressButton();
            }
            return true;
        }
        class_1799 filter = ContraptionControlsMovement.getFilter(ctx);
        boolean disable = true;
        boolean invert = false;
        List<class_1799> disabledActors = contraption.getDisabledActors();
        Iterator<class_1799> iterator = disabledActors.iterator();
        while (iterator.hasNext()) {
            class_1799 class_17992 = iterator.next();
            boolean sameFilter = ContraptionControlsMovement.isSameFilter(class_17992, filter);
            if (class_17992.method_7960()) {
                iterator.remove();
                disable = false;
                if (sameFilter) continue;
                invert = true;
                continue;
            }
            if (!sameFilter) continue;
            iterator.remove();
            disable = false;
            break;
        }
        if (invert) {
            for (MutablePair mutablePair : contraption.getActors()) {
                class_1799 behaviourStack;
                MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)((class_3499.class_3501)mutablePair.left).comp_1342());
                if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)mutablePair.right)) == null || ContraptionControlsMovement.isSameFilter(behaviourStack, filter) || contraption.isActorTypeDisabled(behaviourStack)) continue;
                disabledActors.add(behaviourStack);
                this.send(contraptionEntity, behaviourStack, true);
            }
        }
        if (filter.method_7960()) {
            disabledActors.clear();
        }
        if (disable) {
            disabledActors.add(filter);
        }
        contraption.setActorsActive(filter, !disable);
        ContraptionControlsBlockEntity.sendStatus(player, filter, !disable);
        this.send(contraptionEntity, filter, disable);
        AllSoundEvents.CONTROLLER_CLICK.play(player.method_37908(), null, (class_2382)class_2338.method_49638((class_2374)contraptionEntity.toGlobalVector(class_243.method_24953((class_2382)localPos), 1.0f)), 1.0f, disable ? 0.8f : 1.5f);
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return true;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!filter.method_31573(class_3489.field_15553)) {
            return true;
        }
        Carriage carriage = cce.getCarriage();
        Train train = carriage.train;
        for (Carriage c : train.carriages) {
            CarriageContraptionEntity anyAvailableEntity = c.anyAvailableEntity();
            if (anyAvailableEntity == null) continue;
            Contraption cpt = anyAvailableEntity.getContraption();
            cpt.setActorsActive(filter, !disable);
            ContraptionControlsBlockEntity.sendStatus(player, filter, !disable);
            this.send(anyAvailableEntity, filter, disable);
        }
        return true;
    }

    private void send(AbstractContraptionEntity contraptionEntity, class_1799 filter, boolean disable) {
        class_3218 world = (class_3218)contraptionEntity.method_37908();
        world.method_14178().method_18754((class_1297)contraptionEntity, (class_2596)new ContraptionDisableActorPacket(contraptionEntity.method_5628(), filter, !disable));
    }

    private boolean elevatorInteraction(class_1657 player, class_2338 localPos, AbstractContraptionEntity contraptionEntity, ElevatorContraption contraption, MovementContext ctx) {
        class_1937 level = contraptionEntity.method_37908();
        if (!level.method_8608()) {
            class_2338 pos = class_2338.method_49638((class_2374)contraptionEntity.toGlobalVector(class_243.method_24953((class_2382)localPos), 1.0f));
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)pos, 1.0f, 1.5f);
            AllSoundEvents.CONTRAPTION_ASSEMBLE.play(level, null, (class_2382)pos, 0.75f, 0.8f);
            return true;
        }
        Object object = ctx.temporaryData;
        if (!(object instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
            return false;
        }
        ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
        if (efs.currentTargetY == contraption.clientYTarget) {
            return true;
        }
        AllClientHandle.INSTANCE.sendPacket(player, new ElevatorTargetFloorPacket(contraptionEntity, efs.currentTargetY));
        class_2586 class_25862 = AllClientHandle.INSTANCE.getBlockEntityClientSide(contraption, ctx.localPos);
        if (class_25862 instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)class_25862;
            cbe.pressButton();
        }
        return true;
    }
}

