/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionVisual;
import com.zurrtum.create.client.content.trains.bogey.BogeyVisual;
import com.zurrtum.create.client.content.trains.entity.CarriageClientContraption;
import com.zurrtum.create.client.content.trains.entity.CarriageContraptionEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class CarriageContraptionVisual
extends OrientedContraptionVisual<CarriageContraptionEntity> {
    public static final int MAX_NUM_BOGEYS = 2;
    private final class_4587 poseStack = new class_4587();
    private final CarriageContraption contraption;
    private int numBogeys;
    private final CarriageBogey[] bogeys = new CarriageBogey[2];
    private final BogeyVisual[] visuals = new BogeyVisual[2];
    private final int[] bogeyPos = new int[2];

    public CarriageContraptionVisual(VisualizationContext context, CarriageContraptionEntity entity, float partialTick) {
        super(context, entity, partialTick);
        this.lightPaddingBlocks = 2;
        this.contraption = (CarriageContraption)entity.getContraption();
        this.animate(partialTick);
    }

    @Override
    protected ClientContraption createClientContraption(Contraption contraption) {
        return new CarriageClientContraption((CarriageContraption)contraption);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        super.beginFrame(ctx);
        this.animate(ctx.partialTick());
    }

    @Override
    protected <T extends class_2586> void setupVisualizer(T be, float partialTicks) {
        CarriageContraption cc;
        Contraption contraption = ((CarriageContraptionEntity)this.entity).getContraption();
        if (contraption instanceof CarriageContraption && (cc = (CarriageContraption)contraption).isHiddenInPortal(be.method_11016())) {
            return;
        }
        super.setupVisualizer(be, partialTicks);
    }

    @Override
    protected void setupActor(MutablePair<class_3499.class_3501, MovementContext> actor, VirtualRenderWorld renderLevel) {
        CarriageContraption cc;
        Contraption contraption = ((CarriageContraptionEntity)this.entity).getContraption();
        if (contraption instanceof CarriageContraption && (cc = (CarriageContraption)contraption).isHiddenInPortal(((class_3499.class_3501)actor.left).comp_1341())) {
            return;
        }
        super.setupActor(actor, renderLevel);
    }

    private boolean checkCarriage(float pt) {
        if (this.numBogeys > 0) {
            return true;
        }
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (((CarriageContraptionEntity)this.entity).validForRender && carriage != null) {
            this.numBogeys = 0;
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                this.visuals[this.numBogeys] = AllBogeyStyleRenders.createVisual(bogey.getStyle(), bogey.getSize(), this.visualizationContext, pt, true);
                this.bogeys[this.numBogeys] = bogey;
                this.bogeyPos[this.numBogeys] = bogey.isLeading ? 0 : carriage.bogeySpacing * this.contraption.getAssemblyDirection().method_10160().method_10171().method_10181();
                ++this.numBogeys;
            }
            return true;
        }
        return false;
    }

    private void animate(float partialTick) {
        if (!this.checkCarriage(partialTick)) {
            return;
        }
        float viewYRot = ((CarriageContraptionEntity)this.entity).getViewYRot(partialTick);
        float viewXRot = ((CarriageContraptionEntity)this.entity).getViewXRot(partialTick);
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        int bogeySpacing = carriage.bogeySpacing;
        this.poseStack.method_22903();
        Vector3f visualPosition = this.getVisualPosition(partialTick);
        TransformStack.of(this.poseStack).translate((Vector3fc)visualPosition);
        for (int bogeyIdx = 0; bogeyIdx < this.numBogeys; ++bogeyIdx) {
            if (this.contraption.isHiddenInPortal(this.bogeyPos[bogeyIdx])) {
                this.visuals[bogeyIdx].hide();
                continue;
            }
            this.poseStack.method_22903();
            CarriageBogey bogey = this.bogeys[bogeyIdx];
            CarriageContraptionEntityRenderer.translateBogey(this.poseStack, bogey, bogeySpacing, viewYRot, viewXRot, bogey.yaw.getValue(partialTick), bogey.pitch.getValue(partialTick));
            this.poseStack.method_22904(0.0, -1.5078125, 0.0);
            class_2487 bogeyData = bogey.bogeyData;
            if (bogeyData == null) {
                bogeyData = new class_2487();
            }
            this.visuals[bogeyIdx].update(bogeyData, bogey.wheelAngle.getValue(partialTick), this.poseStack);
            this.poseStack.method_22909();
        }
        this.poseStack.method_22909();
    }

    @Override
    public void _delete() {
        super._delete();
        for (BogeyVisual visual : this.visuals) {
            if (visual == null) continue;
            visual.delete();
        }
    }
}

