/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Transform;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class StationRenderer
extends SafeBlockEntityRenderer<StationBlockEntity> {
    public StationRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(StationBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2338 pos = be.method_11016();
        TrackTargetingBehaviour<GlobalStation> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_1937 level = be.method_10997();
        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, be.depotBehaviour);
        class_2680 trackState = level.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        GlobalStation station = be.getStation();
        boolean isAssembling = (Boolean)be.method_11010().method_11654((class_2769)StationBlock.ASSEMBLING);
        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !be.isVirtual()) {
            StationRenderer.renderFlag(be.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF, be, partialTicks, ms, buffer, light, overlay);
            TrackBlockRenderer renderer = AllTrackRenders.get(track);
            if (renderer != null) {
                ms.method_22903();
                TransformStack.of(ms).translate((class_2382)targetPosition.method_10059((class_2382)pos));
                renderer.render((class_1936)level, trackState, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, TrackTargetingBehaviour.RenderedTrackOverlayType.STATION, 1.0f);
                ms.method_22909();
            }
            return;
        }
        StationRenderer.renderFlag(AllPartialModels.STATION_ASSEMBLE, be, partialTicks, ms, buffer, light, overlay);
        class_2350 direction = be.assemblyDirection;
        if (be.isVirtual() && be.bogeyLocations == null) {
            be.refreshAssemblyInfo();
        }
        if (direction == null || be.assemblyLength == 0 || be.bogeyLocations == null) {
            return;
        }
        ms.method_22903();
        class_2338 offset = targetPosition.method_10059((class_2382)pos);
        ms.method_46416((float)offset.method_10263(), (float)offset.method_10264(), (float)offset.method_10260());
        class_2338.class_2339 currentPos = targetPosition.method_25503();
        PartialModel assemblyOverlay = null;
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            assemblyOverlay = renderer.prepareAssemblyOverlay((class_1922)level, targetPosition, trackState, direction, ms);
        }
        int colorWhenValid = 9876991;
        int colorWhenCarriage = 13303702;
        class_4588 vb = buffer.getBuffer(class_1921.method_23579());
        currentPos.method_10104(direction, 1);
        ms.method_46416(0.0f, 0.0f, 1.0f);
        for (int i = 0; i < be.assemblyLength; ++i) {
            int valid = be.isValidBogeyOffset(i) ? colorWhenValid : -1;
            for (int j : be.bogeyLocations) {
                if (i != j) continue;
                valid = colorWhenCarriage;
                break;
            }
            if (valid != -1 && assemblyOverlay != null) {
                int lightColor = class_761.method_23794((class_1920)level, (class_2338)currentPos);
                SuperByteBuffer sbb = CachedBuffers.partial(assemblyOverlay, trackState);
                sbb.color(valid);
                sbb.light(lightColor);
                sbb.renderInto(ms, vb);
            }
            ms.method_46416(0.0f, 0.0f, 1.0f);
            currentPos.method_10098(direction);
        }
        ms.method_22909();
    }

    public static void renderFlag(PartialModel flag, StationBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!be.resolveFlagAngle()) {
            return;
        }
        SuperByteBuffer flagBB = CachedBuffers.partial(flag, be.method_11010());
        StationRenderer.transformFlag(flagBB, be, partialTicks, be.flagYRot, be.flagFlipped);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)flagBB.translate(0.03125f, 0.0f, 0.0f)).rotateYDegrees(be.flagFlipped ? 0.0f : 180.0f)).translate(-0.03125f, 0.0f, 0.0f)).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    public static void transformFlag(Transform<?> flag, StationBlockEntity be, float partialTicks, int yRot, boolean flipped) {
        float value = be.flag.getValue(partialTicks);
        float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
        if (be.flag.getChaseTarget() > 0.0f && !be.flag.settled() && progress == 1.0f) {
            float wiggleProgress = (value - 0.2f) / 0.8f;
            progress = (float)((double)progress + Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
        }
        float nudge = 0.001953125f;
        ((Transform)((Transform)((Transform)((Transform)flag.center()).rotateYDegrees(yRot)).translate(nudge, 0.59375f, flipped ? 0.875f - nudge : 0.125f + nudge)).uncenter()).rotateXDegrees((float)(flipped ? 1 : -1) * (progress * 90.0f + 270.0f));
    }

    public boolean method_3563() {
        return true;
    }

    public int method_33893() {
        return 192;
    }
}

