/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.google.common.base.Strings;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.enums.PonderKeybinds;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class PonderTooltipHandler {
    private static final Color borderA = new Color(0x5000FF, false).setImmutable();
    private static final Color borderB = new Color(0x5555FF, false).setImmutable();
    private static final Color borderC = new Color(0xFFFFFF, false).setImmutable();
    public static boolean enable = true;
    static LerpedFloat holdKeyProgress = LerpedFloat.linear().startWithValue(0.0);
    static class_1799 hoveredStack = class_1799.field_8037;
    static class_1799 trackingStack = class_1799.field_8037;
    static boolean subject = false;
    static boolean deferTick = false;
    static final List<Consumer<class_1799>> hoveredStackCallbacks = new ArrayList<Consumer<class_1799>>();
    public static final String HOLD_TO_PONDER = "ui.hold_to_ponder";
    public static final String SUBJECT = "ui.subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        class_310 instance = class_310.method_1551();
        class_437 currentScreen = instance.field_1755;
        if (hoveredStack.method_7960() || trackingStack.method_7960()) {
            trackingStack = class_1799.field_8037;
            holdKeyProgress.startWithValue(0.0);
            return;
        }
        float value = holdKeyProgress.getValue();
        if (!subject && class_3675.method_15987((long)instance.method_22683().method_4490(), (int)PonderKeybinds.PONDER.field_1655.method_1444()) && currentScreen != null) {
            if (value >= 1.0f) {
                if (currentScreen instanceof NavigatableSimiScreen) {
                    ((NavigatableSimiScreen)currentScreen).centerScalingOnMouse();
                }
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdKeyProgress.startWithValue(0.0);
                return;
            }
            holdKeyProgress.setValue(Math.min(1.0f, value + Math.max(0.25f, value) * 0.25f));
        } else {
            holdKeyProgress.setValue(Math.max(0.0f, value - 0.05f));
        }
        hoveredStack = class_1799.field_8037;
    }

    public static void addToTooltip(List<class_2561> toolTip, class_1799 stack) {
        class_5250 component;
        if (!enable) {
            return;
        }
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        PonderTooltipHandler.updateHovered(mc, stack);
        if (deferTick) {
            PonderTooltipHandler.deferredTick();
        }
        if (trackingStack != stack) {
            return;
        }
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(mc.method_61966());
        Object object = component = subject ? Ponder.lang().translate(SUBJECT, new Object[0]).component().method_27692(class_124.field_1060) : PonderTooltipHandler.makeProgressBar(Math.min(1.0f, holdKeyProgress.getValue(renderPartialTicks) * 8.0f / 7.0f));
        if (toolTip.size() < 2) {
            toolTip.add((class_2561)component);
        } else {
            toolTip.add(1, (class_2561)component);
        }
    }

    protected static void updateHovered(class_310 instance, class_1799 stack) {
        PonderUI ponderUI;
        class_1799 uiSubject;
        class_437 currentScreen = instance.field_1755;
        boolean inPonderUI = currentScreen instanceof PonderUI;
        class_1799 prevStack = trackingStack;
        hoveredStack = class_1799.field_8037;
        subject = false;
        if (inPonderUI && !(uiSubject = (ponderUI = (PonderUI)currentScreen).getSubject()).method_7960() && stack.method_31574(uiSubject.method_7909())) {
            subject = true;
        }
        if (stack.method_7960()) {
            return;
        }
        if (!PonderIndex.getSceneAccess().doScenesExistForId(RegisteredObjectsHelper.getKeyOrThrow(stack.method_7909()))) {
            return;
        }
        if (prevStack.method_7960() || !prevStack.method_31574(stack.method_7909())) {
            holdKeyProgress.startWithValue(0.0);
        }
        hoveredStack = stack;
        trackingStack = stack;
        for (Consumer<class_1799> hoveredStackCallback : hoveredStackCallbacks) {
            hoveredStackCallback.accept(hoveredStack.method_7972());
        }
    }

    public static Optional<Couple<Color>> handleTooltipColor(class_1799 stack) {
        if (trackingStack != stack) {
            return Optional.empty();
        }
        if (holdKeyProgress.getValue() == 0.0f) {
            return Optional.empty();
        }
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(class_310.method_1551().method_61966());
        float progress = Math.min(1.0f, holdKeyProgress.getValue(renderPartialTicks) * 8.0f / 7.0f);
        Color startC = PonderTooltipHandler.getSmoothColorForProgress(progress);
        Color endC = PonderTooltipHandler.getSmoothColorForProgress(progress);
        return Optional.of(Couple.create(startC, endC));
    }

    private static Color getSmoothColorForProgress(float progress) {
        if ((double)progress < 0.5) {
            return borderA.mixWith(borderB, progress * 2.0f);
        }
        return borderB.mixWith(borderC, (progress - 0.5f) * 2.0f);
    }

    private static class_2561 makeProgressBar(float progress) {
        class_5250 holdW = Ponder.lang().translate(HOLD_TO_PONDER, PonderKeybinds.PONDER.method_16007().method_27661().method_27692(class_124.field_1080)).style(class_124.field_1063).component();
        class_327 fontRenderer = class_310.method_1551().field_1772;
        float charWidth = fontRenderer.method_1727("|");
        float tipWidth = fontRenderer.method_27525((class_5348)holdW);
        int total = (int)(tipWidth / charWidth);
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            Object bars = "";
            bars = (String)bars + String.valueOf(class_124.field_1080) + Strings.repeat((String)"|", (int)current);
            if (progress < 1.0f) {
                bars = (String)bars + String.valueOf(class_124.field_1063) + Strings.repeat((String)"|", (int)(total - current));
            }
            return class_2561.method_43470((String)bars);
        }
        return holdW;
    }

    public static synchronized void registerHoveredPonderStackCallback(Consumer<class_1799> consumer) {
        hoveredStackCallbacks.add(consumer);
    }

    public static synchronized void removeHoveredPonderStackCallback(Consumer<class_1799> consumer) {
        hoveredStackCallbacks.remove(consumer);
    }
}

