/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.ponder.api.registration.LangRegistryAccess;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class PonderLocalization
implements LangRegistryAccess {
    public static final String LANG_PREFIX = "ponder.";
    public static final String UI_PREFIX = "ui.";
    public final Map<class_2960, String> shared = new HashMap<class_2960, String>();
    public final Map<class_2960, Couple<String>> tag = new HashMap<class_2960, Couple<String>>();
    public final Map<class_2960, Map<String, String>> specific = new HashMap<class_2960, Map<String, String>>();

    public void clearAll() {
        this.shared.clear();
        this.tag.clear();
        this.specific.clear();
    }

    public void clearShared() {
        this.shared.clear();
    }

    public void registerShared(class_2960 key, String enUS) {
        this.shared.put(key, enUS);
    }

    public void registerTag(class_2960 key, String title, String description) {
        this.tag.put(key, Couple.create(title, description));
    }

    public void registerSpecific(class_2960 sceneId, String key, String enUS) {
        this.specific.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(class_2960 k) {
        return k.method_12836() + ".ponder.shared." + k.method_12832();
    }

    protected static String langKeyForTag(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832();
    }

    protected static String langKeyForTagDescription(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832() + ".description";
    }

    protected static String langKeyForSpecific(class_2960 sceneId, String k) {
        return sceneId.method_12836() + ".ponder." + sceneId.method_12832() + "." + k;
    }

    @Override
    public String getShared(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? this.shared.get(key) : "unregistered shared entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    @Override
    public String getShared(class_2960 key, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? String.format(this.shared.get(key), params) : "unregistered shared entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])params);
    }

    @Override
    public String getTagName(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getFirst() : "unregistered tag entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    @Override
    public String getTagDescription(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getSecond() : "unregistered tag entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            try {
                return this.specific.get(sceneId).get(k);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            try {
                return String.format(this.specific.get(sceneId).get(k), params);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])params);
    }
}

