/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10418;
import net.minecraft.class_1688;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5601;
import net.minecraft.class_9878;
import net.minecraft.class_9879;
import net.minecraft.class_9883;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class MinecartVisual<T extends class_1688>
extends AbstractEntityVisual<T>
implements SimpleTickableVisual,
SimpleDynamicVisual {
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/entity/minecart.png");
    private static final Material MATERIAL = SimpleMaterial.builder().texture(TEXTURE).mipmap(false).build();
    private final InstanceTree instances;
    @Nullable
    private TransformedInstance contents;
    private final Matrix4fStack stack = new Matrix4fStack(2);
    private class_2680 blockState;

    public MinecartVisual(VisualizationContext ctx, T entity, float partialTick, class_5601 layerLocation) {
        super(ctx, entity, partialTick);
        this.instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(layerLocation, MATERIAL));
        this.blockState = entity.method_7519();
        this.contents = this.createContentsInstance();
        this.updateInstances(partialTick);
        this.updateLight(partialTick);
    }

    @Nullable
    private TransformedInstance createContentsInstance() {
        class_2464 shape = this.blockState.method_26217();
        if (shape == class_2464.field_11455) {
            return null;
        }
        class_2248 block = this.blockState.method_26204();
        if (((class_10418)class_310.method_1551().method_1554().method_65756().get()).field_55270.containsKey(block)) {
            this.instances.visible(false);
            return null;
        }
        return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(this.blockState)).createInstance();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        class_2680 displayBlockState = ((class_1688)this.entity).method_7519();
        if (displayBlockState != this.blockState) {
            this.blockState = displayBlockState;
            if (this.contents != null) {
                this.contents.delete();
            }
            this.contents = this.createContentsInstance();
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (!this.isVisible(context.frustum())) {
            return;
        }
        if (!this.instances.visible()) {
            return;
        }
        this.updateInstances(context.partialTick());
    }

    private void updateInstances(float partialTick) {
        class_9883 controller;
        class_243 pos;
        this.stack.identity();
        double posX = class_3532.method_16436((double)partialTick, (double)((class_1688)this.entity).field_6038, (double)((class_1688)this.entity).method_23317());
        double posY = class_3532.method_16436((double)partialTick, (double)((class_1688)this.entity).field_5971, (double)((class_1688)this.entity).method_23318());
        double posZ = class_3532.method_16436((double)partialTick, (double)((class_1688)this.entity).field_5989, (double)((class_1688)this.entity).method_23321());
        class_2382 renderOrigin = this.renderOrigin();
        this.stack.translate((float)(posX - (double)renderOrigin.method_10263()), (float)(posY - (double)renderOrigin.method_10264()), (float)(posZ - (double)renderOrigin.method_10260()));
        float yaw = class_3532.method_16439((float)partialTick, (float)((class_1688)this.entity).field_5982, (float)((class_1688)this.entity).method_36454());
        long randomBits = (long)((class_1688)this.entity).method_5628() * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float nudgeX = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeY = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float nudgeZ = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        this.stack.translate(nudgeX, nudgeY, nudgeZ);
        float pitch = class_3532.method_16439((float)partialTick, (float)((class_1688)this.entity).field_6004, (float)((class_1688)this.entity).method_36455());
        class_9878 class_98782 = ((class_1688)this.entity).method_61569();
        if (class_98782 instanceof class_9883 && (pos = (controller = (class_9883)class_98782).method_61620(posX, posY, posZ)) != null) {
            class_243 offset1 = controller.method_61619(posX, posY, posZ, (double)0.3f);
            class_243 offset2 = controller.method_61619(posX, posY, posZ, (double)-0.3f);
            if (offset1 == null) {
                offset1 = pos;
            }
            if (offset2 == null) {
                offset2 = pos;
            }
            this.stack.translate((float)(pos.field_1352 - posX), (float)((offset1.field_1351 + offset2.field_1351) / 2.0 - posY), (float)(pos.field_1350 - posZ));
            class_243 vec = offset2.method_1031(-offset1.field_1352, -offset1.field_1351, -offset1.field_1350);
            if (vec.method_1033() != 0.0) {
                vec = vec.method_1029();
                yaw = (float)(Math.atan2(vec.field_1350, vec.field_1352) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vec.field_1351) * 73.0);
            }
        }
        this.stack.translate(0.0f, 0.375f, 0.0f);
        this.stack.rotateY((180.0f - yaw) * ((float)Math.PI / 180));
        this.stack.rotateZ(-pitch * ((float)Math.PI / 180));
        float hurtTime = (float)((class_1688)this.entity).method_54295() - partialTick;
        float damage = ((class_1688)this.entity).method_54294() - partialTick;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            this.stack.rotateX(class_3532.method_15374((float)hurtTime) * hurtTime * damage / 10.0f * (float)((class_1688)this.entity).method_54296() * ((float)Math.PI / 180));
        }
        if (this.contents != null) {
            int displayOffset = ((class_1688)this.entity).method_7514();
            this.stack.pushMatrix();
            this.stack.scale(0.75f, 0.75f, 0.75f);
            this.stack.translate(-0.5f, (float)(displayOffset - 8) / 16.0f, 0.5f);
            this.stack.rotateY(1.5707964f);
            this.updateContents(this.contents, (Matrix4f)this.stack, partialTick);
            this.stack.popMatrix();
        }
        this.stack.scale(-1.0f, -1.0f, 1.0f);
        this.instances.updateInstances((Matrix4fc)this.stack);
        this.updateLight(partialTick);
    }

    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        contents.setTransform((Matrix4fc)pose).setChanged();
    }

    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight(partialTick);
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        FlatLit.relight(packedLight, this.contents);
    }

    @Override
    protected void _delete() {
        this.instances.delete();
        if (this.contents != null) {
            this.contents.delete();
        }
    }

    public static boolean shouldSkipRender(class_1688 minecart) {
        if (minecart.method_61569() instanceof class_9879) {
            return true;
        }
        class_2248 block = minecart.method_7519().method_26204();
        return !((class_10418)class_310.method_1551().method_1554().method_65756().get()).field_55270.containsKey(block);
    }
}

