/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.destination;

import com.zurrtum.create.catnip.data.Glob;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DiscoveredPath;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.schedule.ScheduleRuntime;
import com.zurrtum.create.content.trains.schedule.destination.TextScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalStation;
import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DestinationInstruction
extends TextScheduleInstruction {
    public DestinationInstruction(class_2960 id) {
        super(id);
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    public String getFilter() {
        return this.getLabelText();
    }

    public String getFilterForRegex() {
        return Glob.toRegexPattern(this.getFilter(), "");
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        String regex = this.getFilterForRegex();
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
            if (!globalStation.name.matches(regex)) continue;
            anyMatch = true;
            validStations.add(globalStation);
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            } else {
                train.status.failedNavigationNoTarget(this.getFilter());
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

