package com.zurrtum.create.api.contraption.storage.item;

import com.google.common.collect.ImmutableMap;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import net.minecraft.class_1263;
import net.minecraft.class_2338;

/**
 * Wrapper around many MountedItemStorages, providing access to all of them as one storage.
 * They can still be accessed individually through the map.
 */
public class MountedItemStorageWrapper extends CombinedInvWrapper {
    public final ImmutableMap<class_2338, MountedItemStorage> storages;

    public MountedItemStorageWrapper(ImmutableMap<class_2338, MountedItemStorage> storages) {
        super(storages.values().toArray(class_1263[]::new));
        this.storages = storages;
    }
}
