package com.zurrtum.create.catnip.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public interface CatnipCodecUtils {
    static <T> Optional<T> decode(Codec<T> codec, class_2520 tag) {
        return decode(codec, class_2509.field_11560, tag);
    }

    static <T> Optional<T> decode(Codec<T> codec, class_7225.class_7874 registries, class_2520 tag) {
        return decode(codec, class_6903.method_46632(class_2509.field_11560, registries), tag);
    }

    static <T, S> Optional<T> decode(Codec<T> codec, DynamicOps<S> ops, S s) {
        return Optional.ofNullable(codec.decode(ops, s).mapOrElse(Pair::getFirst, error -> null));
    }

    static <T> Optional<class_2520> encode(Codec<T> codec, T t) {
        return encode(codec, class_2509.field_11560, t);
    }

    static <T> Optional<class_2520> encode(Codec<T> codec, class_7225.class_7874 registries, T t) {
        return encode(codec, class_6903.method_46632(class_2509.field_11560, registries), t);
    }

    static <T, S> Optional<S> encode(Codec<T> codec, DynamicOps<S> ops, T t) {
        return Optional.ofNullable(codec.encodeStart(ops, t).mapOrElse(tag -> tag, error -> null));
    }
}