package com.zurrtum.create.client;

import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.client.content.trains.bogey.BogeyVisual;
import com.zurrtum.create.client.content.trains.bogey.SizeRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class AllBogeyStyleRenders {
    public static final Map<class_2960, Map<BogeySize, SizeRenderer>> ALL = new HashMap<>();

    public static void render(
        BogeyStyle style,
        BogeySize size,
        float partialTick,
        class_4587 poseStack,
        class_4597 buffers,
        int light,
        int overlay,
        float wheelAngle,
        @Nullable class_2487 bogeyData,
        boolean inContraption
    ) {
        Map<BogeySize, SizeRenderer> sizeRenderers = ALL.get(style.id);
        if (sizeRenderers == null) {
            return;
        }
        if (bogeyData == null)
            bogeyData = new class_2487();
        poseStack.method_22904(0, -1.5 - 1 / 128f, 0);
        sizeRenderers.get(size).renderer().render(bogeyData, wheelAngle, partialTick, poseStack, buffers, light, overlay, inContraption);
    }

    @Nullable
    public static BogeyVisual createVisual(BogeyStyle style, BogeySize size, VisualizationContext ctx, float partialTick, boolean inContraption) {
        Map<BogeySize, SizeRenderer> sizeRenderers = ALL.get(style.id);
        if (sizeRenderers == null) {
            return null;
        }
        return sizeRenderers.get(size).visualizer().createVisual(ctx, partialTick, inContraption);
    }

    @SafeVarargs
    public static void register(BogeyStyle style, Supplier<SizeRenderer>... renderers) {
        Set<BogeySize> sizes = style.validSizes();
        if (sizes.size() != renderers.length) {
            throw new IllegalArgumentException("Mismatched number of renderers for bogey style " + style.id);
        }
        int i = 0;
        Map<BogeySize, SizeRenderer> sizeRenderers = new IdentityHashMap<>();
        for (BogeySize size : sizes) {
            sizeRenderers.put(size, renderers[i].get());
            i++;
        }
        ALL.put(style.id, sizeRenderers);
    }

    public static void register() {
        register(AllBogeyStyles.STANDARD, SizeRenderer::small, SizeRenderer::large);
    }
}
