package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public abstract class NavigatableSimiScreen extends AbstractSimiScreen {

    public static final Couple<Color> COLOR_NAV_ARROW = Couple.create(new Color(0x80_aa9999, true), new Color(0x30_aa9999)).map(Color::setImmutable);

    protected static boolean currentlyRenderingPreviousScreen = false;

    protected int depthPointX, depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0).chase(0, .1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0).chase(0, 0.075f, LerpedFloat.Chaser.LINEAR);
    @Nullable
    protected BoxWidget backTrack;

    public NavigatableSimiScreen() {
        class_1041 window = class_310.method_1551().method_22683();
        depthPointX = window.method_4486() / 2;
        depthPointY = window.method_4502() / 2;
    }

    @Override
    public void method_25419() {
        ScreenOpener.clearStack();
        super.method_25419();
    }

    @Override
    public void method_25432() {
        if (backTrack != null) {
            backTrack.getRenderElement().clear();
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        transition.tickChaser();
        arrowAnimation.tickChaser();
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        backTrack = null;
        List<class_437> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty())
            return;

        method_37063(backTrack = new BoxWidget(31, field_22790 - 31 - 20).withBounds(20, 20).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)
            .enableFade(0, 5).withPadding(2, 2).fade(1).withCallback(() -> ScreenOpener.openPreviousScreen(this, null)));

        class_437 previousScreen = screenHistory.getFirst();
        if (previousScreen instanceof NavigatableSimiScreen screen) {
            screen.initBackTrackIcon(backTrack);
        } else {
            backTrack.showing(PonderGuiTextures.ICON_DISABLE);
        }

    }

    /**
     * Called when {@code this} represents the previous screen to
     * initialize the {@code backTrack} icon of the current screen.
     *
     * @param backTrack The backTrack button of the current screen.
     */
    protected abstract void initBackTrackIcon(BoxWidget backTrack);

    protected class_2561 backTrackingComponent() {
        if (ScreenOpener.getBackStepScreen() instanceof NavigatableSimiScreen) {
            return Lang.builder("catnip").translate("gui.step_back").component();
        }

        return Lang.builder("catnip").translate("gui.exit").component();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        //		renderZeloBreadcrumbs(ms, mouseX, mouseY, partialTicks);
        if (backTrack == null)
            return;

        Matrix3x2fStack poseStack = graphics.method_51448();

        int x = class_3532.method_48781(arrowAnimation.getValue(partialTicks), -9, 21);
        int maxX = backTrack.method_46426() + backTrack.method_25368();
        Couple<Color> colors = COLOR_NAV_ARROW;

        poseStack.pushMatrix();
        poseStack.translate(0, 0);
        if (x + 30 < backTrack.method_46426())
            UIRenderHelper.breadcrumbArrow(graphics, x + 30, field_22790 - 51, maxX - (x + 30), 20, 5, colors);

        UIRenderHelper.breadcrumbArrow(graphics, x, field_22790 - 51, 30, 20, 5, colors);
        UIRenderHelper.breadcrumbArrow(graphics, x - 30, field_22790 - 51, 30, 20, 5, colors);
        poseStack.popMatrix();

        poseStack.pushMatrix();
        poseStack.translate(0, 0);
        if (backTrack.method_25367()) {
            class_2561 component = backTrackingComponent();
            graphics.method_51439(
                field_22793,
                component,
                41 - field_22793.method_27525(component) / 2,
                field_22790 - 16,
                UIRenderHelper.COLOR_TEXT_DARKER.getFirst().getRGB(),
                false
            );
            if (class_3532.method_15347(arrowAnimation.getValue(), arrowAnimation.getChaseTarget())) {
                arrowAnimation.setValue(1);
                arrowAnimation.setValue(1);// called twice to also set the previous value to 1
            }
        }
        poseStack.popMatrix();
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!isCurrentlyRenderingPreviousScreen())
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderWindowBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (transition.getChaseTarget() == 0 || transition.settled()) {
            return;
        }

        Matrix3x2fStack ms = graphics.method_51448();

        class_1041 window = field_22787.method_22683();
        float guiScaledWidth = window.method_4486();
        float guiScaledHeight = window.method_4502();

        class_437 lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float tValue = transition.getValue(partialTicks);
        float tValueAbsolute = Math.abs(tValue);

        // draw last screen into buffer
        /*if (lastScreen != null && lastScreen != this && !transition.settled()) {
            currentlyRenderingPreviousScreen = true;
            ms.pushMatrix();
            lastScreen.render(graphics, 0, 0, partialTicks);
            ms.popMatrix();

            ms.pushMatrix();
            int dpx = (int) (guiScaledWidth / 2);
            int dpy = (int) (guiScaledHeight / 2);
            if (lastScreen instanceof NavigatableSimiScreen navigableScreen && tValue > 0) {
                dpx = navigableScreen.depthPointX;
                dpy = navigableScreen.depthPointY;
            }

            float scale = 1 + (0.2f * tValue);

            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0F, guiScaledWidth, guiScaledHeight, 0.0F, 1000.0F, 3000.0F);
            MatrixStack poseStack2 = new MatrixStack();
            poseStack2.peek().getPositionMatrix().set(matrix4f);
            poseStack2.translate(dpx, dpy, 0);
            poseStack2.scale(scale, scale, 1);
            poseStack2.translate(-dpx, -dpy, 0);


            UIRenderHelper.drawFramebuffer(poseStack2, 1f - tValueAbsolute);
            ms.popMatrix();
            currentlyRenderingPreviousScreen = false;
        }*/

        // modify current screen as well
        float scale = tValue > 0 ? 1 - 0.5f * (1 - tValueAbsolute) : 1 + .5f * (1 - tValueAbsolute);
        int dpx = (int) (guiScaledWidth / 2);
        //dpx = depthPointX;
        int dpy = (int) (guiScaledHeight / 2);
        //dpy = depthPointY;
        ms.translate(dpx, dpy);
        ms.scale(scale, scale);
        ms.translate(-dpx, -dpy);
    }

    @Override
    public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == GLFW.GLFW_KEY_BACKSPACE) {
            ScreenOpener.openPreviousScreen(this, null);
            return true;
        }
        return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        depthPointX = x;
        depthPointY = y;
    }

    public void centerScalingOnMouse() {
        class_1041 w = field_22787.method_22683();
        double mouseX = field_22787.field_1729.method_1603() * w.method_4486() / w.method_4480();
        double mouseY = field_22787.field_1729.method_1604() * w.method_4502() / w.method_4507();
        centerScalingOn((int) mouseX, (int) mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        List<class_437> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty())
            return;

        history.add(0, field_22787.field_1755);
        int spacing = 20;

        List<String> names = new ArrayList<>();
        for (class_437 screen : history)
            names.add(NavigatableSimiScreen.screenTitle(screen));

        int bWidth = 0;
        for (String name : names) {
            bWidth += field_22793.method_1727(name) + spacing;
        }

        MutableInt x = new MutableInt(field_22789 - bWidth);
        MutableInt y = new MutableInt(field_22790 - 18);
        MutableBoolean first = new MutableBoolean(true);

        if (x.getValue() < 25)
            x.setValue(25);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(0, 0);
        names.forEach(s -> {
            int sWidth = field_22793.method_1727(s);
            UIRenderHelper.breadcrumbArrow(
                graphics,
                x.getValue(),
                y.getValue(),
                sWidth + spacing,
                14,
                spacing / 2,
                new Color(0xdd101010),
                new Color(0x44101010)
            );
            graphics.method_51433(field_22793, s, x.getValue() + 5, y.getValue() + 3, first.getValue() ? 0xffeeffee : 0xffddeeff, true);
            first.setFalse();

            x.add(sWidth + spacing);
        });
        poseStack.popMatrix();
    }

    public static boolean isCurrentlyRenderingPreviousScreen() {
        return currentlyRenderingPreviousScreen;
    }

    private static String screenTitle(class_437 screen) {
        if (screen instanceof NavigatableSimiScreen)
            return ((NavigatableSimiScreen) screen).getBreadcrumbTitle();
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return this.getClass().getSimpleName();
    }
}
