package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2459;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_7833;
import net.minecraft.client.render.*;
import java.util.HashMap;
import java.util.Map;

public class BlockTransformElementRenderer extends class_11239<BlockTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public BlockTransformElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    @Override
    public void render(BlockTransformRenderState block, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        Object key = block.getKey();
        GpuTexture texture = TEXTURES.get(key);
        if (texture == null) {
            float size = block.size() * windowScaleFactor;
            texture = GpuTexture.create((int) size);
            TEXTURES.put(key, texture);
            RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
            texture.prepare();
            matrices.method_22903();
            matrices.method_46416(size / 2, size / 2, 0);
            if (block.padding() != 0) {
                size -= block.padding() * windowScaleFactor;
            }
            matrices.method_22905(size, size, size);
            if (block.zRot() != 0) {
                matrices.method_22907(class_7833.field_40718.rotation(block.zRot()));
            }
            if (block.xRot() != 0) {
                matrices.method_22907(class_7833.field_40714.rotation(block.xRot()));
            }
            if (block.yRot() != 0) {
                matrices.method_22907(class_7833.field_40716.rotation(block.yRot()));
            }
            matrices.method_22905(1, -1, 1);
            matrices.method_46416(-0.5F, -0.5F, -0.5F);
            class_310 mc = class_310.method_1551();
            class_1921 layer;
            if (block.state().method_27852(class_2246.field_10523) && block.state().method_11654(class_2459.field_11446)) {
                layer = class_1921.method_23581();
            } else {
                layer = class_4696.method_23679(block.state()) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
            }
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(block.state());
            mc.method_1541()
                .method_3355(block.state(), class_2338.field_10980, world, matrices, field_59933.getBuffer(layer), false, block.parts());
            field_59933.method_22993();
            matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            block.method_72127(),
            block.comp_4122(),
            block.comp_4123(),
            block.comp_4124(),
            block.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            block.scissor(),
            null
        ));
    }

    @Override
    protected void render(BlockTransformRenderState block, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Block Transform";
    }

    @Override
    public Class<BlockTransformRenderState> method_70903() {
        return BlockTransformRenderState.class;
    }
}
